/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.apiwrap.store;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import icu.develop.apiwrap.ApiWrapProperties;
import icu.develop.apiwrap.WrapStore;
import java.util.concurrent.TimeUnit;

public class LocalWrapStore
implements WrapStore {
    private static final String PREFIX_SECRET = "com:eqxiu:wrap:secret:";
    private static final String PREFIX_SIGN = "com:eqxiu:wrap:sign:";
    private final Cache<String, String> guavaCache = CacheBuilder.newBuilder().build();
    private final Cache<String, String> expireCache;

    public LocalWrapStore(ApiWrapProperties apiWrapProperties) {
        this.expireCache = CacheBuilder.newBuilder().expireAfterAccess(apiWrapProperties.getLegalTime() == null ? 300L : apiWrapProperties.getLegalTime(), TimeUnit.SECONDS).build();
    }

    @Override
    public void putSecret(String appKey, String appSecret) {
        this.guavaCache.put((Object)(PREFIX_SECRET + appKey), (Object)appSecret);
    }

    @Override
    public String getSecret(String appKey) {
        return (String)this.guavaCache.getIfPresent((Object)(PREFIX_SECRET + appKey));
    }

    @Override
    public void putSign(String appKey, long timestamp, int nonce, String signature) {
        String key = PREFIX_SIGN + appKey + "_" + timestamp + "_" + nonce;
        this.expireCache.put((Object)key, (Object)signature);
    }

    @Override
    public String getSign(String appKey, long timestamp, int nonce) {
        String key = PREFIX_SIGN + appKey + "_" + timestamp + "_" + nonce;
        return (String)this.expireCache.getIfPresent((Object)key);
    }
}

