/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.apiwrap.store;

import icu.develop.apiwrap.ApiWrapProperties;
import icu.develop.apiwrap.store.LocalWrapStore;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisWrapStore
extends LocalWrapStore {
    private static final String PREFIX_SECRET = "com:eqxiu:wrap:secret:";
    private static final String PREFIX_SIGN = "com:eqxiu:wrap:sign:";
    private final StringRedisTemplate stringRedisTemplate;
    private final Long legalTime;

    public RedisWrapStore(ApiWrapProperties apiWrapProperties, StringRedisTemplate stringRedisTemplate) {
        super(apiWrapProperties);
        this.stringRedisTemplate = stringRedisTemplate;
        this.legalTime = apiWrapProperties.getLegalTime() == null ? 300L : apiWrapProperties.getLegalTime();
    }

    @Override
    public void putSecret(String appKey, String appSecret) {
        this.stringRedisTemplate.opsForValue().set((Object)(PREFIX_SECRET + appKey), (Object)appSecret);
    }

    @Override
    public String getSecret(String appKey) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(PREFIX_SECRET + appKey));
    }

    @Override
    public void putSign(String appKey, long timestamp, int nonce, String signature) {
        String key = PREFIX_SIGN + appKey + "_" + timestamp + "_" + nonce;
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)signature, this.legalTime.longValue(), TimeUnit.SECONDS);
    }

    @Override
    public String getSign(String appKey, long timestamp, int nonce) {
        String key = PREFIX_SIGN + appKey + "_" + timestamp + "_" + nonce;
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }
}

