/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.apiwrap.client;

import icu.develop.apiwrap.WrapData;
import icu.develop.apiwrap.WrapRequest;
import icu.develop.apiwrap.WrapSigner;
import icu.develop.apiwrap.client.WrapOperation;
import icu.develop.apiwrap.handler.DefaultWrapSigner;
import icu.develop.apiwrap.utils.NonceUtils;

public class WrapClient
implements WrapOperation {
    private String appKey;
    private WrapSigner wrapSigner;

    private WrapClient(String appKey, String appSecret) {
        this.appKey = appKey;
        this.wrapSigner = new DefaultWrapSigner(appSecret);
    }

    @Override
    public <T extends WrapData> WrapRequest<T> wrap(T source) {
        WrapRequest wrapRequest = new WrapRequest();
        wrapRequest.setData(source);
        wrapRequest.setAppKey(this.appKey);
        wrapRequest.setTimestamp(System.currentTimeMillis());
        wrapRequest.setNonce(NonceUtils.nonce().intValue());
        wrapRequest.setSignature(this.wrapSigner.signature(wrapRequest));
        return wrapRequest;
    }

    public static WrapClient create(String appKey, String appSecret) {
        return new WrapClient(appKey, appSecret);
    }
}

