/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.apiwrap;

public enum Algorithm {
    ES256("SHA256withECDSA"),
    ES384("SHA384withECDSA"),
    ES512("SHA512withECDSA"),
    HS256("HmacSHA256"),
    HS384("HmacSHA384"),
    HS512("HmacSHA512"),
    PS256("SHA-256"),
    PS384("SHA-384"),
    PS512("SHA-512"),
    RS256("SHA256withRSA"),
    RS384("SHA384withRSA"),
    RS512("SHA512withRSA"),
    NONE("None");

    private String algorithm;

    private Algorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public static Algorithm fromName(String name) {
        for (Algorithm alg : Algorithm.values()) {
            if (!alg.getName().equals(name)) continue;
            return alg;
        }
        return null;
    }

    public String getName() {
        return this.algorithm;
    }

    public int getSaltLength() {
        switch (this) {
            case PS256: {
                return 32;
            }
            case PS384: {
                return 48;
            }
            case PS512: {
                return 64;
            }
        }
        throw new IllegalStateException("An incompatible algorithm was provided, this method is only used for RSASSA-PSS algorithms.");
    }
}

