/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.apiwrap;

import icu.develop.apiwrap.Algorithm;
import icu.develop.apiwrap.Wrap;
import icu.develop.apiwrap.exception.InvalidWrapSignatureException;
import icu.develop.apiwrap.exception.WrapSigningException;
import icu.develop.apiwrap.exception.WrapVerifierException;
import icu.develop.apiwrap.security.CryptoProvider;
import icu.develop.apiwrap.security.DefaultCryptoProvider;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACWrap
implements Wrap {
    private final Algorithm algorithm;
    private final CryptoProvider cryptoProvider;
    private final byte[] secret;

    private HMACWrap(Algorithm algorithm, byte[] secret, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(cryptoProvider);
        Objects.requireNonNull(secret);
        this.algorithm = algorithm;
        this.cryptoProvider = cryptoProvider;
        this.secret = secret;
    }

    private HMACWrap(Algorithm algorithm, String secret, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(cryptoProvider);
        Objects.requireNonNull(secret);
        this.algorithm = algorithm;
        this.cryptoProvider = cryptoProvider;
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] sign(String payload) {
        Objects.requireNonNull(payload);
        try {
            Mac mac = this.cryptoProvider.getMacInstance(this.algorithm.getName());
            mac.init(new SecretKeySpec(this.secret, this.algorithm.getName()));
            return mac.doFinal(payload.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new WrapSigningException("An unexpected exception occurred when attempting to sign the JWT", e);
        }
    }

    @Override
    public void verify(byte[] payload, byte[] signature) {
        Objects.requireNonNull(this.algorithm);
        Objects.requireNonNull(payload);
        Objects.requireNonNull(signature);
        try {
            Mac mac = this.cryptoProvider.getMacInstance(this.algorithm.getName());
            mac.init(new SecretKeySpec(this.secret, this.algorithm.getName()));
            byte[] actualSignature = mac.doFinal(payload);
            if (!MessageDigest.isEqual(signature, actualSignature)) {
                throw new InvalidWrapSignatureException("invalid signature exception");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new WrapVerifierException("An unexpected exception occurred when attempting to verify the wrap", e);
        }
    }

    public static HMACWrap newSHA256Wrap(byte[] secret) {
        return HMACWrap.newSHA256Wrap(secret, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACWrap newSHA256Wrap(String secret) {
        return HMACWrap.newSHA256Wrap(secret, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACWrap newSHA256Wrap(String secret, CryptoProvider cryptoProvider) {
        return new HMACWrap(Algorithm.HS256, secret, cryptoProvider);
    }

    public static HMACWrap newSHA256Wrap(byte[] secret, CryptoProvider cryptoProvider) {
        return new HMACWrap(Algorithm.HS256, secret, cryptoProvider);
    }

    public static HMACWrap newSHA384Wrap(byte[] secret) {
        return HMACWrap.newSHA384Wrap(secret, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACWrap newSHA384Wrap(String secret) {
        return HMACWrap.newSHA384Wrap(secret, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACWrap newSHA384Wrap(byte[] secret, CryptoProvider cryptoProvider) {
        return new HMACWrap(Algorithm.HS384, secret, cryptoProvider);
    }

    public static HMACWrap newSHA384Wrap(String secret, CryptoProvider cryptoProvider) {
        return new HMACWrap(Algorithm.HS384, secret, cryptoProvider);
    }

    public static HMACWrap newSHA512Wrap(byte[] secret) {
        return HMACWrap.newSHA512Wrap(secret, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACWrap newSHA512Wrap(String secret) {
        return HMACWrap.newSHA512Wrap(secret, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACWrap newSHA512Wrap(String secret, CryptoProvider cryptoProvider) {
        return new HMACWrap(Algorithm.HS512, secret, cryptoProvider);
    }

    public static HMACWrap newSHA512Wrap(byte[] secret, CryptoProvider cryptoProvider) {
        return new HMACWrap(Algorithm.HS512, secret, cryptoProvider);
    }
}

