/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.apiwrap.handler;

import icu.develop.apiwrap.HMACWrap;
import icu.develop.apiwrap.WrapData;
import icu.develop.apiwrap.WrapRequest;
import icu.develop.apiwrap.WrapSigner;
import icu.develop.apiwrap.utils.WrapUtils;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;

public class DefaultWrapSigner
implements WrapSigner {
    private final String appSecret;

    public DefaultWrapSigner(String appSecret) {
        this.appSecret = appSecret;
    }

    @Override
    public <T extends WrapData> String signature(WrapRequest<T> data) {
        Map<String, Object> beanMap = WrapUtils.beanToMap(data.getData());
        beanMap.put("appKey", data.getAppKey());
        beanMap.put("timestamp", data.getTimestamp());
        beanMap.put("nonce", data.getNonce());
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(beanMap);
        StringBuilder plainText = new StringBuilder();
        for (Map.Entry entry : sortedMap.entrySet()) {
            plainText.append(entry.getKey()).append("=").append(entry.getValue());
            plainText.append("&");
        }
        plainText.deleteCharAt(plainText.length() - 1);
        HMACWrap wrap = HMACWrap.newSHA256Wrap(this.appSecret);
        return Base64.getEncoder().encodeToString(wrap.sign(plainText.toString()));
    }
}

