/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.limiter;

import icu.develop.limiter.LimiterProceeding;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateLimiterConfig;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLimiterProceeding {
    private static final Logger log = LoggerFactory.getLogger(RedisLimiterProceeding.class);
    private final RedissonClient redissonClient;

    public RedisLimiterProceeding(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public <T> T limiter(String limiterKey, long timeout, long count, LimiterProceeding<T> proceeding) throws Throwable {
        RRateLimiter rateLimiter = this.getRateLimiter(limiterKey, count, timeout);
        boolean limitSuccess = rateLimiter.tryAcquire();
        if (limitSuccess) {
            return proceeding.proceed();
        }
        throw new RuntimeException("\u8d85\u8fc7\u9650\u5b9a\u901f\u7387,\u4e0d\u80fd\u9891\u7e41\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    private RRateLimiter getRateLimiter(String limiterKey, long internalRate, long internalRateInterval) {
        RRateLimiter rateLimiter = this.redissonClient.getRateLimiter(limiterKey);
        if (!rateLimiter.isExists()) {
            rateLimiter.trySetRate(RateType.OVERALL, internalRate, internalRateInterval, RateIntervalUnit.SECONDS);
        }
        RateLimiterConfig rateLimiterConfig = rateLimiter.getConfig();
        Long rateInterval = rateLimiterConfig.getRateInterval();
        Long rate = rateLimiterConfig.getRate();
        if (TimeUnit.MILLISECONDS.convert(internalRateInterval, TimeUnit.SECONDS) != rateInterval.longValue() || internalRate != rate) {
            rateLimiter.delete();
            rateLimiter.trySetRate(RateType.OVERALL, internalRate, internalRateInterval, RateIntervalUnit.SECONDS);
        }
        return rateLimiter;
    }
}

