/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.limiter.aspect;

import icu.develop.limiter.RedisLimiterProceeding;
import icu.develop.limiter.annotation.RedisRateLimiter;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Aspect
public class RedisRateLimiterAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisRateLimiterAspect.class);
    private final RedisLimiterProceeding redisLimiterProceeding;

    public RedisRateLimiterAspect(RedisLimiterProceeding redisLimiterProceeding) {
        this.redisLimiterProceeding = redisLimiterProceeding;
    }

    @Pointcut(value="@annotation(redisRateLimiter)")
    public void pointcut(RedisRateLimiter redisRateLimiter) {
    }

    @Around(value="pointcut(redisRateLimiter)")
    public Object around(ProceedingJoinPoint joinPoint, RedisRateLimiter redisRateLimiter) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        String methodName = method.getName();
        String className = method.getDeclaringClass().getName();
        String limitKey = StringUtils.hasText((String)redisRateLimiter.limiterKey()) ? "prm:common:limiter:" + redisRateLimiter.limiterKey() : "prm:common:limiter:" + className + ":" + methodName;
        return this.redisLimiterProceeding.limiter(limitKey, redisRateLimiter.timeout(), redisRateLimiter.limitCount(), () -> ((ProceedingJoinPoint)joinPoint).proceed());
    }
}

