/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.lock;

import icu.develop.lock.LockProceeding;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLockProceeding {
    private static final Logger log = LoggerFactory.getLogger(RedisLockProceeding.class);
    private final RedissonClient redissonClient;

    public RedisLockProceeding(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T locked(String lockKey, long waitTime, long leaseTime, LockProceeding<T> proceeding) throws Throwable {
        String finalLockKey = "bmp:prm:common:lock:" + lockKey;
        try {
            RLock lock = this.redissonClient.getLock(finalLockKey);
            boolean lockSuccess = lock.tryLock(waitTime, leaseTime, TimeUnit.SECONDS);
            if (!lockSuccess) throw new RuntimeException("\u4e0d\u80fd\u9891\u7e41\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            try {
                T t = proceeding.proceed();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("\u4e0d\u80fd\u9891\u7e41\u64cd\u4f5c:{}", (Object)e.getLocalizedMessage(), (Object)e);
            throw new RuntimeException("\u4e0d\u80fd\u9891\u7e41\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }
}

