/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.lock.aspect;

import icu.develop.lock.RedisLockProceeding;
import icu.develop.lock.annotation.RedisLock;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Aspect
public class RedisLockAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisLockAspect.class);
    private final RedisLockProceeding redisLockProceeding;

    public RedisLockAspect(RedisLockProceeding redisLockProceeding) {
        this.redisLockProceeding = redisLockProceeding;
    }

    @Pointcut(value="@annotation(redisLock)")
    public void pointcut(RedisLock redisLock) {
    }

    @Around(value="pointcut(redisLock)")
    public Object around(ProceedingJoinPoint joinPoint, RedisLock redisLock) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        String methodName = method.getName();
        String className = method.getDeclaringClass().getName();
        String lockKey = StringUtils.hasText((String)redisLock.lockKey()) ? "bmp:prm:common:lock:" + redisLock.lockKey() : "bmp:prm:common:lock:" + className + ":" + methodName;
        return this.redisLockProceeding.locked(lockKey, redisLock.waitTime(), redisLock.lockedTime(), () -> ((ProceedingJoinPoint)joinPoint).proceed());
    }
}

