/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter;

import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.PipeFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class BasePipeFilter<T, R>
implements PipeFilter<T, R> {
    private final List<String> filterParams = new ArrayList<String>();
    private final List<Object> extraList = new ArrayList<Object>();
    protected String noticePrefix;

    protected abstract String filterName();

    protected boolean isValidity(PipeDataWrapper<R> apply) {
        R data = apply.getData();
        if (Objects.nonNull(data)) {
            return !(data instanceof Collection) && !(data instanceof Map);
        }
        return true;
    }

    public void setNoticePrefix(String noticePrefix) {
        this.noticePrefix = noticePrefix;
    }

    protected String errorPrefix() {
        return this.noticePrefix + String.format("[%s]\u6307\u4ee4\u9519\u8bef:", this.filterName());
    }

    @Override
    public List<String> params() {
        return this.filterParams;
    }

    @Override
    public BasePipeFilter<T, R> addParams(String ... params) {
        this.params().addAll(Arrays.asList(params));
        return this;
    }

    @Override
    public List<Object> extra() {
        return this.extraList;
    }

    @Override
    public PipeFilter<T, R> addExtra(Object ... extra) {
        this.extra().addAll(Arrays.asList(extra));
        return this;
    }

    protected boolean verify(PipeDataWrapper<T> wrapper) {
        return Objects.nonNull(wrapper) && (wrapper.isErrorContinue() || wrapper.success());
    }

    protected PipeDataWrapper<R> handlerApply(PipeDataWrapper<T> wrapper) {
        return null;
    }

    @Override
    public PipeDataWrapper<R> apply(PipeDataWrapper<T> wrapper) {
        PipeDataWrapper<R> dataWrapper = this.handlerApply(wrapper).errorContinue(wrapper.isErrorContinue());
        if (wrapper.isErrorContinue() && !wrapper.success()) {
            dataWrapper.setMessage(wrapper.getMessage());
            dataWrapper.setStatus(wrapper.getStatus());
        }
        return dataWrapper;
    }
}

