/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter;

import java.io.Serializable;

public class PipeDataWrapper<R>
implements Serializable {
    private boolean errorContinue = false;
    private int status;
    private String message;
    private R data;
    private Object extra;

    public PipeDataWrapper(int status, String message, R data) {
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public PipeDataWrapper<R> errorContinue(boolean errorContinue) {
        this.errorContinue = errorContinue;
        return this;
    }

    public static <R> PipeDataWrapper<R> success(R data) {
        return new PipeDataWrapper<R>(200, "OK", data);
    }

    public static <R> PipeDataWrapper<R> error(String error, R data) {
        return new PipeDataWrapper<R>(500, error, data);
    }

    public static <R> PipeDataWrapper<R> error(String error) {
        return new PipeDataWrapper<Object>(500, error, null);
    }

    public boolean success() {
        return this.status == 200;
    }

    public boolean isErrorContinue() {
        return this.errorContinue;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public R getData() {
        return this.data;
    }

    public Object getExtra() {
        return this.extra;
    }

    public void setErrorContinue(boolean errorContinue) {
        this.errorContinue = errorContinue;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(R data) {
        this.data = data;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PipeDataWrapper)) {
            return false;
        }
        PipeDataWrapper other = (PipeDataWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isErrorContinue() != other.isErrorContinue()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        R this$data = this.getData();
        R other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Object this$extra = this.getExtra();
        Object other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !this$extra.equals(other$extra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PipeDataWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isErrorContinue() ? 79 : 97);
        result = result * 59 + this.getStatus();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        R $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Object $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        return result;
    }

    public String toString() {
        return "PipeDataWrapper(errorContinue=" + this.isErrorContinue() + ", status=" + this.getStatus() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", extra=" + this.getExtra() + ")";
    }
}

