/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.PipeFilterPool;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class PipeFilterFactory
extends BasePipeFilter<Object, Object> {
    public static PipeFilterFactory createPipeFilter() {
        return new PipeFilterFactory();
    }

    public PipeFilterFactory registerPipeFilter(String name, Supplier<BasePipeFilter<Object, Object>> pipeFilter) {
        PipeFilterPool.INSTANCE.addPipeFilter(name, pipeFilter);
        return this;
    }

    protected PipeDataWrapper<Object> applyAfter(PipeDataWrapper<Object> selfWrapper) {
        return selfWrapper;
    }

    protected void noticePrefix(BasePipeFilter<Object, Object> pipeFilter, String variableName) {
        pipeFilter.setNoticePrefix(String.format("[%s]\u53d8\u91cf", variableName));
    }

    protected void additionalInfo(BasePipeFilter<Object, Object> pipeFilter) {
    }

    @Override
    public PipeDataWrapper<Object> apply(PipeDataWrapper<Object> value) {
        if (PipeFilterUtils.isEmpty(this.params())) {
            throw new RuntimeException("\u7ba1\u9053\u5b57\u7b26\u4e32\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String variable = this.params().get(0);
        if (StringUtils.isBlank(variable)) {
            throw new RuntimeException("\u7ba1\u9053\u5b57\u7b26\u4e32\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String[] pipeArray = PipeFilterUtils.getPipelines(variable);
        Objects.requireNonNull(pipeArray, "\u7ba1\u9053\u5b57\u7b26\u4e32\u683c\u5f0f\u4e0d\u6b63\u786e");
        if (pipeArray.length <= 1) {
            throw new RuntimeException("\u7ba1\u9053\u5b57\u7b26\u4e32\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String variableName = pipeArray[0].trim();
        ArrayList<BasePipeFilter<Object, Object>> pipeFilterList = new ArrayList<BasePipeFilter<Object, Object>>();
        for (int i = 1; i < pipeArray.length; ++i) {
            String filterName;
            String[] expressArray;
            if (StringUtils.isBlank(pipeArray[i]) || StringUtils.isBlank((expressArray = PipeFilterUtils.getPipeFilter(pipeArray[i], 2))[0]) || StringUtils.isBlank(filterName = PipeFilterUtils.trim(expressArray[0]).toLowerCase())) continue;
            Supplier<BasePipeFilter<Object, Object>> supplier = PipeFilterPool.INSTANCE.getPipeFilter(filterName);
            if (Objects.isNull(supplier)) {
                throw new RuntimeException(String.format("\u6ca1\u6709[%s]\u7684\u7ba1\u9053\u8fc7\u6ee4\u5668", filterName));
            }
            BasePipeFilter<Object, Object> pipeFilter = supplier.get();
            if (Objects.nonNull(pipeFilter)) {
                pipeFilterList.add(pipeFilter);
            }
            if (expressArray.length > 1 && StringUtils.isNotBlank(expressArray[1])) {
                String[] paramArray = PipeFilterUtils.getPipeFilterParams(PipeFilterUtils.trim(expressArray[1]));
                pipeFilter.addParams(paramArray);
            }
            this.noticePrefix(pipeFilter, variableName);
            this.additionalInfo(pipeFilter);
        }
        if (PipeFilterUtils.isEmpty(pipeFilterList)) {
            return value;
        }
        Function currFilter = (Function)pipeFilterList.get(0);
        for (int i = 1; i < pipeFilterList.size(); ++i) {
            currFilter = currFilter.andThen((Function)pipeFilterList.get(i));
        }
        return this.applyAfter((PipeDataWrapper)currFilter.apply(value));
    }

    @Override
    protected String filterName() {
        return "factory";
    }
}

