/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.constant;

public enum EscapeEnums {
    ES1("\\\"", "&quot"),
    ES2("<", "&lt"),
    ES3(">", "&gt"),
    ES4(" ", "&nbsp"),
    ES5("\u00a5", "&yen"),
    ES6("|", "&brvbar"),
    ES7("\u00a7", "&sect"),
    ES8("\u00ab", "&laquo"),
    ES9("\u00ae", "&reg"),
    ES10("#", "&#35"),
    ES11("$", "&#36"),
    ES12("%", "&#37"),
    ES13("'", "&#39"),
    ES14("(", "&#40"),
    ES15(")", "&#41"),
    ES16("*", "&#42"),
    ES17("+", "&#43"),
    ES18(",", "&#44"),
    ES19("-", "&#45"),
    ES20(".", "&#46"),
    ES21("/", "&#47"),
    ES22(":", "&#58"),
    ES23(";", "&#59"),
    ES24("=", "&#61"),
    ES25("[", "&#91"),
    ES27("]", "&#93"),
    ES28("_", "&#95"),
    ES99("&", "&amp"),
    ES98("", "&empty");

    private final String ch;
    private final String escape;

    private EscapeEnums(String ch, String escape) {
        this.ch = ch;
        this.escape = escape;
    }

    public static EscapeEnums match(String escape) {
        for (EscapeEnums value : EscapeEnums.values()) {
            if (!escape.equals(value.escape)) continue;
            return value;
        }
        return null;
    }

    public String getCh() {
        return this.ch;
    }

    public String getEscape() {
        return this.escape;
    }
}

