/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCalculatorFilter
extends BasePipeFilter<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCalculatorFilter.class);
    public static final String INT = "int";
    public static final String NUMBER = "number";
    public static final String REGEX = "_";

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        double number2;
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u7f3a\u5931\u53c2\u6570");
        }
        String params1 = this.params().get(0);
        if (StringUtils.isBlank(params1)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u53c2\u6570\u4e3a\u7a7a");
        }
        double number1 = 0.0;
        if (value instanceof Number) {
            number1 = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            try {
                number1 = Double.parseDouble((String)value);
            }
            catch (Exception e) {
                number1 = 0.0;
            }
        }
        try {
            number2 = Double.parseDouble(params1);
        }
        catch (Exception e) {
            number2 = 0.0;
        }
        double result = this.calculator(number1, number2);
        return this.showDataWrapper(result);
    }

    private PipeDataWrapper<Object> showDataWrapper(double result) {
        if (this.params().size() <= 1) {
            return PipeDataWrapper.success(result);
        }
        String params2 = this.params().get(1);
        if (StringUtils.isBlank(params2)) {
            return PipeDataWrapper.success(result);
        }
        String[] params2Array = params2.split(REGEX);
        if (INT.equalsIgnoreCase(params2Array[0])) {
            return PipeDataWrapper.success(BigDecimal.valueOf(result).intValue());
        }
        if (NUMBER.equalsIgnoreCase(params2Array[0])) {
            if (params2Array.length > 1) {
                if (StringUtils.isNumeric(params2Array[1])) {
                    int scale = Integer.parseInt(params2Array[1]);
                    BigDecimal bigDecimal = BigDecimal.valueOf(result).setScale(scale, RoundingMode.HALF_UP);
                    if (scale == 0) {
                        return PipeDataWrapper.success(bigDecimal.intValue());
                    }
                    return PipeDataWrapper.success(bigDecimal.doubleValue());
                }
                log.warn("Calculator\u6307\u4ee4[cal-add,cal-sub,cal-mul,cal-div]\u4f20\u9012\u7684\u4f4d\u6570\u53c2\u6570\u4e0d\u662f\u6570\u5b57");
                return PipeDataWrapper.success(result);
            }
            return PipeDataWrapper.success(result);
        }
        return PipeDataWrapper.success(result);
    }

    private double calculator(double number1, double number2) {
        double result = 0.0;
        switch (this.filterName()) {
            case "cal-add": {
                result = Calculator.add(number1, number2);
                break;
            }
            case "cal-sub": {
                result = Calculator.subtract(number1, number2);
                break;
            }
            case "cal-mul": {
                result = Calculator.multiply(number1, number2);
                break;
            }
            case "cal-div": {
                if (number2 == 0.0) {
                    throw new RuntimeException("cal-div\u6307\u4ee4\u9664\u6570\u4e3a0\u4e0d\u652f\u6301");
                }
                result = Calculator.divide(number1, number2);
                break;
            }
            default: {
                throw new RuntimeException("Calculator\u6307\u4ee4\u4e0d\u652f\u6301");
            }
        }
        return result;
    }

    public static class Calculator {
        public static double add(double a, double b) {
            return a + b;
        }

        public static double subtract(double a, double b) {
            return a - b;
        }

        public static double multiply(double a, double b) {
            return a * b;
        }

        public static double divide(double a, double b) {
            if (b == 0.0) {
                throw new IllegalArgumentException("\u9664\u6570\u4e0d\u80fd\u4e3a0");
            }
            return a / b;
        }
    }
}

