/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.provider.AbstractMatchListFilter;
import icu.develop.expression.filter.utils.BeanMapUtils;
import icu.develop.expression.filter.utils.NumberUtils;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import icu.develop.expression.filter.utils.TrafficUnit;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapSizeFilter
extends AbstractMatchListFilter {
    private static final Logger log = LoggerFactory.getLogger(AbstractMapSizeFilter.class);
    private static final String NUMBER_REG = "^[0-9]+(.[0-9]+)?$";

    @Override
    protected boolean matchProcess(String source, String match) {
        return source.equalsIgnoreCase(match);
    }

    protected abstract String matchSizeTip();

    protected PipeDataWrapper<Object> getPipeDataOfMap(Object value, String center) {
        Map colMap = value instanceof Map ? (Map)value : BeanMapUtils.create(value);
        PipeDataWrapper<Map> result = null;
        for (Map.Entry entry : colMap.entrySet()) {
            if (Objects.isNull(entry.getKey()) || !this.matchProcess(entry.getKey().toString(), center)) continue;
            if (Objects.nonNull(entry.getValue()) && this.matchMaxSize(entry.getValue(), this.params().get(1))) {
                result = PipeDataWrapper.success(colMap);
                break;
            }
            result = PipeDataWrapper.error(this.errorPrefix() + String.format(this.matchSizeTip() + ":%s", this.params().get(1)), colMap);
            break;
        }
        return result;
    }

    @Override
    protected PipeDataWrapper<Object> instructHandle(Object value, String center) {
        if (value instanceof Collection) {
            ArrayList<Object> resultList = new ArrayList<Object>();
            Collection collection = (Collection)value;
            for (Object col : collection) {
                if (Objects.isNull(col)) continue;
                if (col instanceof String || col instanceof Collection) {
                    log.warn(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u652f\u6301\u96c6\u5408\u5957\u96c6\u5408\u7684\u60c5\u51b5");
                    continue;
                }
                PipeDataWrapper<Object> result = this.getPipeDataOfMap(col, center);
                if (!Objects.nonNull(result) || !result.success()) continue;
                resultList.add(result.getData());
            }
            if (PipeFilterUtils.isEmpty(resultList)) {
                return PipeDataWrapper.error(this.errorPrefix() + String.format("\u6ca1\u6709\u5305\u542b[%s]\u7684\u6570\u636e\u6216\u6570\u636e" + this.matchSizeTip() + "[%s]", center, this.params().get(1)));
            }
            return PipeDataWrapper.success(resultList);
        }
        if (value instanceof String) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u5b57\u7b26\u4e32");
        }
        PipeDataWrapper<Object> result = this.getPipeDataOfMap(value, center);
        if (Objects.nonNull(result) && result.success()) {
            return PipeDataWrapper.success(result.getData());
        }
        return PipeDataWrapper.error(this.errorPrefix() + String.format("\u6ca1\u6709\u5305\u542b[%s]\u7684\u6570\u636e\u6216\u6570\u636e" + this.matchSizeTip() + "[%s]", center, this.params().get(1)), result.getData());
    }

    @Override
    protected PipeDataWrapper<Object> singleParamsHandle(Object value) {
        String center = this.params().get(0);
        return this.instructHandle(value, center);
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        Object dataObj;
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u7f3a\u5931\u53c2\u6570");
        }
        if (this.params().size() != 2) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u53c2\u6570\u4e2a\u6570\u53ea\u80fd\u662f2\u4e2a");
        }
        if (StringUtils.isBlank(this.params().get(0))) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(this.params().get(1))) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (value instanceof Collection || value instanceof Map) {
            dataObj = value;
        } else {
            if (value instanceof String) {
                return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u5b57\u7b26\u4e32");
            }
            dataObj = BeanMapUtils.create(value);
        }
        return this.singleParamsHandle(dataObj);
    }

    private boolean matchMaxSize(Object value, String param) {
        Double valueInt;
        Double paramInt;
        block12: {
            try {
                paramInt = this.getParamInt(param);
                if (value instanceof String) {
                    String val = ((String)value).trim();
                    if (!StringUtils.isNumeric(val)) {
                        if (val.length() > 2) {
                            String number = val.substring(0, val.length() - 2);
                            String unit = val.substring(val.length() - 2);
                            TrafficUnit trafficUnit = TrafficUnit.ofName(unit);
                            if (Objects.isNull((Object)trafficUnit)) {
                                unit = val.substring(val.length() - 1);
                                number = val.substring(0, val.length() - 1);
                                trafficUnit = TrafficUnit.ofName(unit);
                            }
                            if (Objects.isNull((Object)trafficUnit)) {
                                throw new RuntimeException(this.errorPrefix() + "\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u5982:[kb/mb/gb]");
                            }
                            if (!number.matches(NUMBER_REG)) {
                                throw new RuntimeException(this.errorPrefix() + "\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u5982:[kb/mb/gb]");
                            }
                            valueInt = trafficUnit.toB(NumberUtils.parseDouble(number, NumberUtils.FormatProperty.EMPTY));
                        } else {
                            valueInt = TrafficUnit.KB.toB(NumberUtils.parseDouble(param, NumberUtils.FormatProperty.EMPTY));
                        }
                    } else {
                        valueInt = TrafficUnit.KB.toB(NumberUtils.parseDouble(param, NumberUtils.FormatProperty.EMPTY));
                    }
                    break block12;
                }
                if (value instanceof Number) {
                    valueInt = TrafficUnit.KB.toB(((Number)value).doubleValue());
                    break block12;
                }
                throw new RuntimeException(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u7c7b\u578b\u5e94\u8be5\u662f\u6570\u5b57");
            }
            catch (NumberFormatException e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new RuntimeException(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u7c7b\u578b\u5e94\u8be5\u662f\u6570\u5b57");
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.matchSize(valueInt, paramInt);
    }

    protected abstract boolean matchSize(Double var1, Double var2);

    private Double getParamInt(String param) throws ParseException {
        double paramInt;
        if (!StringUtils.isNumeric(param)) {
            if (param.length() > 2) {
                String number = param.substring(0, param.length() - 2);
                String unit = param.substring(param.length() - 2);
                TrafficUnit trafficUnit = TrafficUnit.ofName(unit);
                if (Objects.isNull((Object)trafficUnit)) {
                    unit = param.substring(param.length() - 1);
                    number = param.substring(0, param.length() - 1);
                    trafficUnit = TrafficUnit.ofName(unit);
                }
                if (Objects.isNull((Object)trafficUnit)) {
                    throw new RuntimeException(this.errorPrefix() + "\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u5982:[kb/mb/gb]");
                }
                if (!number.matches(NUMBER_REG)) {
                    throw new RuntimeException(this.errorPrefix() + "\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u5982:[kb/mb/gb]");
                }
                paramInt = trafficUnit.toB(NumberUtils.parseDouble(number, NumberUtils.FormatProperty.EMPTY));
            } else {
                paramInt = TrafficUnit.KB.toB(NumberUtils.parseDouble(param, NumberUtils.FormatProperty.EMPTY));
            }
        } else {
            paramInt = TrafficUnit.KB.toB(NumberUtils.parseDouble(param, NumberUtils.FormatProperty.EMPTY));
        }
        return paramInt;
    }
}

