/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.BeanMapUtils;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMatchFilter
extends BasePipeFilter<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMatchFilter.class);

    protected abstract boolean matchProcess(String var1, String var2);

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u7f3a\u5931\u53c2\u6570");
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object dataObj = value instanceof String || value instanceof Collection || value instanceof Map ? value : BeanMapUtils.create(value);
        if (this.params().size() == 1) {
            return this.singleParamsHandle(dataObj);
        }
        return this.moreParamsHandle(dataObj);
    }

    protected PipeDataWrapper<Object> singleParamsHandle(Object value) {
        String center = this.params().get(0);
        if (StringUtils.isBlank(center)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PipeDataWrapper<Object> objectPipeDataWrapper = this.instructHandle(value, center);
        if (!objectPipeDataWrapper.success()) {
            String message = objectPipeDataWrapper.getMessage();
            objectPipeDataWrapper.setMessage(this.errorPrefix() + String.format("\u6ca1\u6709\u5305\u542b[%s]\u7684\u6570\u636e", message));
        }
        return objectPipeDataWrapper;
    }

    protected PipeDataWrapper<Object> moreParamsHandle(Object value) {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<String> error = new ArrayList<String>();
        for (String center : this.params()) {
            if (Objects.isNull(center)) continue;
            PipeDataWrapper<Object> itemDataWrapper = this.instructHandle(value, center);
            Object data = itemDataWrapper.getData();
            if (itemDataWrapper.success()) {
                if (data instanceof Collection) {
                    Collection collection = (Collection)data;
                    result.addAll(collection);
                    continue;
                }
                result.add(data);
                continue;
            }
            error.add(itemDataWrapper.getMessage());
        }
        if (PipeFilterUtils.isEmpty(error)) {
            return PipeDataWrapper.success(result);
        }
        return PipeDataWrapper.error(this.errorPrefix() + String.format("\u6ca1\u6709\u5305\u542b[%s]\u7684\u6570\u636e", String.join((CharSequence)",", error)), result);
    }

    protected PipeDataWrapper<Object> instructHandle(Object value, String center) {
        if (value instanceof Collection) {
            Object result = null;
            Collection collection = (Collection)value;
            for (Object col : collection) {
                if (Objects.isNull(col)) continue;
                if (col instanceof String) {
                    String cel = (String)col;
                    if (!StringUtils.isNotBlank(cel) || !this.matchProcess(cel, center)) continue;
                    result = cel;
                    break;
                }
                if (col instanceof Collection) {
                    log.warn(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u652f\u6301\u96c6\u5408\u5957\u96c6\u5408\u7684\u60c5\u51b5");
                    break;
                }
                result = this.getObjectOfMap(col, center);
                if (!Objects.nonNull(result)) continue;
                break;
            }
            if (Objects.isNull(result)) {
                return PipeDataWrapper.error(center);
            }
            return PipeDataWrapper.success(result);
        }
        if (value instanceof String) {
            String col = (String)value;
            if (StringUtils.isNotBlank(col) && this.matchProcess(col, center)) {
                return PipeDataWrapper.success(col);
            }
            return PipeDataWrapper.error(center);
        }
        Object result = this.getObjectOfMap(value, center);
        if (Objects.isNull(result)) {
            return PipeDataWrapper.error(center);
        }
        return PipeDataWrapper.success(result);
    }

    protected Object getObjectOfMap(Object value, String center) {
        Map colMap = value instanceof Map ? (Map)value : BeanMapUtils.create(value);
        Object result = null;
        for (Map.Entry entry : colMap.entrySet()) {
            if (Objects.isNull(entry.getKey()) || !this.matchProcess(entry.getKey().toString(), center)) continue;
            if (!Objects.nonNull(entry.getValue())) break;
            result = entry.getValue();
            break;
        }
        return result;
    }
}

