/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.provider.AbstractMatchFilter;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMatchListFilter
extends AbstractMatchFilter {
    private static final Logger log = LoggerFactory.getLogger(AbstractMatchListFilter.class);

    @Override
    protected PipeDataWrapper<Object> instructHandle(Object value, String center) {
        if (value instanceof Collection) {
            ArrayList<Object> resultList = new ArrayList<Object>();
            Collection collection = (Collection)value;
            for (Object col : collection) {
                Object result = null;
                if (Objects.isNull(col)) continue;
                if (col instanceof String) {
                    String cel = (String)col;
                    if (StringUtils.isNotBlank(cel) && this.matchProcess(cel, center)) {
                        result = cel;
                    }
                } else {
                    if (col instanceof Collection) {
                        log.warn(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u652f\u6301\u96c6\u5408\u5957\u96c6\u5408\u7684\u60c5\u51b5");
                        continue;
                    }
                    result = this.getObjectOfMap(col, center);
                }
                if (!Objects.nonNull(result)) continue;
                resultList.add(result);
            }
            if (PipeFilterUtils.isEmpty(resultList)) {
                return PipeDataWrapper.error(center);
            }
            return PipeDataWrapper.success(resultList);
        }
        if (value instanceof String) {
            String col = (String)value;
            if (StringUtils.isNotBlank(col) && this.matchProcess(col, center)) {
                return PipeDataWrapper.success(col);
            }
            return PipeDataWrapper.error(center);
        }
        Object result = this.getObjectOfMap(value, center);
        if (Objects.isNull(result)) {
            return PipeDataWrapper.error(center);
        }
        return PipeDataWrapper.success(result);
    }
}

