/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.NumberUtils;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import icu.develop.expression.filter.utils.TrafficUnit;
import java.text.ParseException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSizeFilter
extends BasePipeFilter<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSizeFilter.class);
    private static final String NUMBER_REG = "^[0-9]+(.[0-9]+)?$";

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        Double valueInt;
        Double paramInt;
        TrafficUnit trafficUnit;
        block17: {
            if (!this.verify(wrapper)) {
                return wrapper;
            }
            Object value = wrapper.getData();
            if (Objects.isNull(value)) {
                return PipeDataWrapper.success("");
            }
            if (PipeFilterUtils.isEmpty(this.params())) {
                return PipeDataWrapper.error(this.errorPrefix() + "\u53c2\u6570\u4e3a\u7a7a");
            }
            if (this.params().size() != 1) {
                return PipeDataWrapper.error(this.errorPrefix() + "\u4ec5\u652f\u63011\u4e2a\u53c2\u6570");
            }
            String param = this.params().get(0);
            if (StringUtils.isBlank(param)) {
                return PipeDataWrapper.error(this.errorPrefix() + "\u53c2\u6570\u4e3a\u7a7a");
            }
            param = param.trim();
            trafficUnit = TrafficUnit.KB;
            try {
                paramInt = this.getParamInt(param);
                if (value instanceof String) {
                    String val = ((String)value).trim();
                    if (!StringUtils.isNumeric(val)) {
                        if (val.length() > 2) {
                            String number = val.substring(0, val.length() - 2);
                            String unit = val.substring(val.length() - 2);
                            trafficUnit = TrafficUnit.ofName(unit);
                            if (Objects.isNull((Object)trafficUnit)) {
                                unit = val.substring(val.length() - 1);
                                number = val.substring(0, val.length() - 1);
                                trafficUnit = TrafficUnit.ofName(unit);
                            }
                            if (Objects.isNull((Object)trafficUnit)) {
                                throw new RuntimeException(this.errorPrefix() + "\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u5982:[kb/mb/gb]");
                            }
                            if (!number.matches(NUMBER_REG)) {
                                throw new RuntimeException(this.errorPrefix() + "\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u5982:[kb/mb/gb]");
                            }
                            valueInt = trafficUnit.toB(NumberUtils.parseDouble(number, NumberUtils.FormatProperty.EMPTY));
                        } else {
                            valueInt = TrafficUnit.KB.toB(NumberUtils.parseDouble(param, NumberUtils.FormatProperty.EMPTY));
                        }
                    } else {
                        valueInt = TrafficUnit.KB.toB(NumberUtils.parseDouble(param, NumberUtils.FormatProperty.EMPTY));
                    }
                    break block17;
                }
                if (value instanceof Number) {
                    valueInt = TrafficUnit.KB.toB(((Number)value).doubleValue());
                    break block17;
                }
                throw new RuntimeException(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u7c7b\u578b\u5e94\u8be5\u662f\u6570\u5b57");
            }
            catch (NumberFormatException e) {
                log.warn(e.getMessage(), (Throwable)e);
                return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u7c7b\u578b\u5e94\u8be5\u662f\u6570\u5b57");
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                return PipeDataWrapper.error(e.getMessage());
            }
        }
        return this.matchSize(valueInt, paramInt, trafficUnit);
    }

    private Double getParamInt(String param) throws ParseException {
        double paramInt;
        if (!StringUtils.isNumeric(param)) {
            if (param.length() > 2) {
                String number = param.substring(0, param.length() - 2);
                String unit = param.substring(param.length() - 2);
                TrafficUnit trafficUnit = TrafficUnit.ofName(unit);
                if (Objects.isNull((Object)trafficUnit)) {
                    unit = param.substring(param.length() - 1);
                    number = param.substring(0, param.length() - 1);
                    trafficUnit = TrafficUnit.ofName(unit);
                }
                if (Objects.isNull((Object)trafficUnit)) {
                    throw new RuntimeException(this.errorPrefix() + "\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u5982:[kb/mb/gb]");
                }
                if (!number.matches(NUMBER_REG)) {
                    throw new RuntimeException(this.errorPrefix() + "\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u5982:[kb/mb/gb]");
                }
                paramInt = trafficUnit.toB(NumberUtils.parseDouble(number, NumberUtils.FormatProperty.EMPTY));
            } else {
                paramInt = TrafficUnit.KB.toB(NumberUtils.parseDouble(param, NumberUtils.FormatProperty.EMPTY));
            }
        } else {
            paramInt = TrafficUnit.KB.toB(NumberUtils.parseDouble(param, NumberUtils.FormatProperty.EMPTY));
        }
        return paramInt;
    }

    protected static String getResult(double valueInt, TrafficUnit trafficUnit) {
        if (TrafficUnit.isB(trafficUnit)) {
            return TrafficUnit.B.toB(valueInt) + trafficUnit.name();
        }
        if (TrafficUnit.isKB(trafficUnit)) {
            return TrafficUnit.B.toKB(valueInt) + trafficUnit.name();
        }
        if (TrafficUnit.isMB(trafficUnit)) {
            return TrafficUnit.B.toMB(valueInt) + trafficUnit.name();
        }
        if (TrafficUnit.isGB(trafficUnit)) {
            return TrafficUnit.B.toGB(valueInt) + trafficUnit.name();
        }
        return TrafficUnit.B.toKB(valueInt) + trafficUnit.name();
    }

    protected abstract PipeDataWrapper<Object> matchSize(Double var1, Double var2, TrafficUnit var3);
}

