/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.provider.AbstractEchoFilter;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Objects;

public class ConditionEchoFilter
extends AbstractEchoFilter {
    public static final int INT_3 = 3;

    @Override
    protected String filterName() {
        return "condition-echo";
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (Objects.isNull(wrapper)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u8f93\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!wrapper.success()) {
            return PipeDataWrapper.error(wrapper.getMessage(), "");
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.success("");
        }
        if (!(value instanceof String)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u662f\u5b57\u7b26\u4e32");
        }
        String val = (String)value;
        if (StringUtils.isBlank(val)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u8f93\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.success("\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.params().size() != 3) {
            return PipeDataWrapper.success("\u8f93\u5165\u53c2\u6570\u4e2a\u6570\u4e3a3\u4e2a");
        }
        String delimiter = this.params().get(0);
        String successVal = this.params().get(1);
        String errorVal = this.params().get(2);
        if (Objects.equals(val, delimiter)) {
            return PipeDataWrapper.success(successVal);
        }
        return PipeDataWrapper.success(errorVal);
    }
}

