/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.DateUtils;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Date;
import java.util.Objects;

public class DateFormatFilter
extends BasePipeFilter<Object, Object> {
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";

    @Override
    protected String filterName() {
        return "date-format";
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (value instanceof Date) {
            String format = PipeFilterUtils.isEmpty(this.params()) ? DEFAULT_FORMAT : (StringUtils.isBlank(this.params().get(0)) ? DEFAULT_FORMAT : this.params().get(0));
            Date date = (Date)value;
            return PipeDataWrapper.success(DateUtils.format(date, format));
        }
        if (value instanceof String) {
            return PipeDataWrapper.success(value);
        }
        return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u4f20\u5165\u6570\u636e\u4e0d\u662fDate\u6216\u5b57\u7b26\u4e32");
    }
}

