/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.constant.EscapeEnums;
import icu.develop.expression.filter.provider.AbstractEchoFilter;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Objects;

public class EchoFilter
extends AbstractEchoFilter {
    @Override
    protected String filterName() {
        return "echo";
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (Objects.isNull(wrapper)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u8f93\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!wrapper.success()) {
            return PipeDataWrapper.error(wrapper.getMessage(), "");
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.success("");
        }
        if (!(value instanceof String)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u662f\u5b57\u7b26\u4e32");
        }
        String val = (String)value;
        if (StringUtils.isBlank(val)) {
            return PipeDataWrapper.success("");
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.success("");
        }
        String delimiter = this.params().get(0);
        AbstractEchoFilter.Delimiter delimiterEnum = AbstractEchoFilter.Delimiter.ofValue(delimiter);
        if (Objects.nonNull((Object)delimiterEnum)) {
            return PipeDataWrapper.success(val + delimiterEnum.getDelimiter());
        }
        String delimiterEscape = delimiter;
        EscapeEnums delimiterEscapeEnums = EscapeEnums.match(delimiter);
        if (Objects.nonNull((Object)delimiterEscapeEnums)) {
            delimiterEscape = delimiterEscapeEnums.getCh();
        }
        return PipeDataWrapper.success(val + delimiterEscape);
    }
}

