/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.provider.AbstractEchoFilter;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtractStringFilter
extends AbstractEchoFilter {
    private static final int PARAMS_SIZE = 2;

    @Override
    protected String filterName() {
        return "extract";
    }

    @Override
    protected PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PipeFilterUtils.isEmpty(this.params()) || this.params().size() != 2) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u53c2\u6570\u4e0b\u6807\u4e3a\u7a7a\u6216\u662f\u8d85\u8fc7\u4e24\u4e2a");
        }
        AbstractEchoFilter.ExtractIndex extractIndex = this.indexHandle(this.params().toArray(new String[0]));
        if (value instanceof String) {
            String serializable = this.extractString(value, extractIndex.begin(), extractIndex.end());
            if (StringUtils.isBlank(serializable)) {
                return PipeDataWrapper.error(this.errorPrefix() + "\u6ca1\u6709\u5339\u914d\u5230\u6570\u636e", value);
            }
            return PipeDataWrapper.success(serializable);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            List collect = collection.stream().map(item -> this.extractString(value, extractIndex.begin(), extractIndex.end())).collect(Collectors.toList());
            if (PipeFilterUtils.isEmpty(collect)) {
                return PipeDataWrapper.error(this.errorPrefix() + "\u6ca1\u6709\u5339\u914d\u5230\u6570\u636e", value);
            }
            return PipeDataWrapper.success(collect);
        }
        return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u8f93\u5165\u6570\u636e\u4e0d\u662f\u5b57\u7b26\u4e32\u6216\u5b57\u7b26\u4e32\u96c6\u5408");
    }
}

