/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.PipeFilterPool;
import icu.develop.expression.filter.constant.EscapeEnums;
import icu.develop.expression.filter.provider.AbstractEchoFilter;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ListEchoConditionFilter
extends AbstractEchoFilter {
    @Override
    protected String filterName() {
        return "list-echo-condition";
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        String delimiter;
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.success("");
        }
        if (!(value instanceof Collection)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u662f\u96c6\u5408");
        }
        List collection = (List)value;
        if (PipeFilterUtils.isEmpty(collection)) {
            return PipeDataWrapper.success("");
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.success(collection.stream().map(String::valueOf).collect(Collectors.joining(AbstractEchoFilter.Delimiter.WRAP.getDelimiter())));
        }
        String delimiterEscape = delimiter = this.params().get(0);
        AbstractEchoFilter.Delimiter delimiterEnum = AbstractEchoFilter.Delimiter.ofValue(delimiter);
        if (Objects.isNull((Object)delimiterEnum)) {
            EscapeEnums oldCharEscapeEnums = EscapeEnums.match(delimiter);
            if (Objects.nonNull((Object)oldCharEscapeEnums)) {
                delimiterEscape = oldCharEscapeEnums.getCh();
            }
        } else {
            delimiterEscape = delimiterEnum.getDelimiter();
        }
        String subFilter = this.params().get(1);
        if (StringUtils.isBlank(subFilter)) {
            return PipeDataWrapper.success(collection.stream().map(String::valueOf).collect(Collectors.joining(delimiterEscape)));
        }
        String[] expressArray = PipeFilterUtils.getPipeFilter(subFilter, 2);
        if (StringUtils.isBlank(expressArray[0])) {
            return PipeDataWrapper.success(collection.stream().map(String::valueOf).collect(Collectors.joining(delimiterEscape)));
        }
        String filterName = PipeFilterUtils.trim(expressArray[0]).toLowerCase();
        if (StringUtils.isBlank(filterName)) {
            return PipeDataWrapper.success(collection.stream().map(String::valueOf).collect(Collectors.joining(delimiterEscape)));
        }
        Supplier<BasePipeFilter<Object, Object>> pipeFilterSupplier = PipeFilterPool.INSTANCE.getPipeFilter(filterName);
        if (Objects.isNull(pipeFilterSupplier)) {
            return PipeDataWrapper.success(collection.stream().map(String::valueOf).collect(Collectors.joining(delimiterEscape)));
        }
        BasePipeFilter<Object, Object> pipeFilter = pipeFilterSupplier.get();
        if (expressArray.length > 1 && StringUtils.isNotBlank(expressArray[1])) {
            String[] paramArray = PipeFilterUtils.getPipeFilterParams(PipeFilterUtils.trim(expressArray[1]));
            pipeFilter.addParams(paramArray);
        }
        StringBuilder concat = new StringBuilder();
        for (Object coll : collection) {
            PipeDataWrapper<Object> apply = pipeFilter.apply(PipeDataWrapper.success(concat + coll.toString()));
            if (!apply.success()) break;
            concat.append(coll).append(delimiterEscape);
        }
        return PipeDataWrapper.success(concat.substring(0, concat.lastIndexOf(delimiterEscape)));
    }
}

