/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.constant.EscapeEnums;
import icu.develop.expression.filter.provider.AbstractEchoFilter;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ListEchoFilter
extends AbstractEchoFilter {
    @Override
    protected String filterName() {
        return "list-echo";
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.success("");
        }
        if (!(value instanceof Collection)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u662f\u96c6\u5408");
        }
        List collection = (List)value;
        if (PipeFilterUtils.isEmpty(collection)) {
            return PipeDataWrapper.success("");
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.success(collection.stream().map(String::valueOf).collect(Collectors.joining(AbstractEchoFilter.Delimiter.WRAP.getDelimiter())));
        }
        String delimiter = this.params().get(0);
        AbstractEchoFilter.Delimiter delimiterEnum = AbstractEchoFilter.Delimiter.ofValue(delimiter);
        if (Objects.nonNull((Object)delimiterEnum)) {
            return PipeDataWrapper.success(collection.stream().map(String::valueOf).collect(Collectors.joining(delimiterEnum.getDelimiter())));
        }
        String delimiterEscape = delimiter;
        EscapeEnums oldCharEscapeEnums = EscapeEnums.match(delimiter);
        if (Objects.nonNull((Object)oldCharEscapeEnums)) {
            delimiterEscape = oldCharEscapeEnums.getCh();
        }
        return PipeDataWrapper.success(collection.stream().map(String::valueOf).collect(Collectors.joining(delimiterEscape)));
    }
}

