/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListIndexFilter
extends BasePipeFilter<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(ListIndexFilter.class);

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u7f3a\u5931\u53c2\u6570");
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(value instanceof Collection)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u662f\u96c6\u5408");
        }
        List collection = (List)value;
        if (PipeFilterUtils.isEmpty(collection)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PipeFilterUtils.isEmpty(this.params()) || this.params().size() > 1) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u53c2\u6570\u4e0b\u6807\u4e3a\u7a7a\u6216\u662f\u8d85\u8fc7\u4e00\u4e2a");
        }
        String index = this.params().get(0);
        if (StringUtils.isBlank(index)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u53c2\u6570\u4e0b\u6807\u4e3a\u7a7a");
        }
        try {
            int ind = Integer.parseInt(index);
            if (ind < 0) {
                ind = 0;
            }
            if (ind >= 1) {
                --ind;
            }
            if (ind > collection.size() - 1) {
                return PipeDataWrapper.error(this.errorPrefix() + "\u4e0b\u6807\u8d85\u51fa\u6570\u636e\u6700\u5927\u8303\u56f4");
            }
            return PipeDataWrapper.success(collection.get(ind));
        }
        catch (NumberFormatException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return PipeDataWrapper.error(this.errorPrefix() + "\u4e0b\u6807\u8f6c\u6362\u9519\u8bef");
        }
    }

    @Override
    protected String filterName() {
        return "list-index";
    }
}

