/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListRangeFilter
extends BasePipeFilter<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(ListRangeFilter.class);
    private static final int PARAMS_NUM = 2;

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(value instanceof Collection)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u662f\u96c6\u5408");
        }
        List collection = (List)value;
        if (PipeFilterUtils.isEmpty(this.params()) || this.params().size() > 2) {
            return PipeDataWrapper.error(this.errorPrefix() + "[list-range:index,count]\u4f20\u5165\u53c2\u6570\u4e0b\u6807\u4e3a\u7a7a\u6216\u662f\u8d85\u8fc7\u4e24\u4e2a");
        }
        String index = this.params().get(0);
        if (StringUtils.isBlank(index)) {
            return PipeDataWrapper.error(this.errorPrefix() + "[list-range:index,count]\u4e2d\u4f20\u5165\u53c2\u6570index\u4e3a\u7a7a");
        }
        String count = this.params().get(1);
        if (StringUtils.isBlank(count)) {
            return PipeDataWrapper.error(this.errorPrefix() + "[list-range:index,count]\u4e2d\u4f20\u5165\u53c2\u6570count\u4e3a\u7a7a");
        }
        try {
            int countInt;
            int fromIndex = Integer.parseInt(index);
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (fromIndex >= 1) {
                --fromIndex;
            }
            if ((countInt = Integer.parseInt(count)) < 1) {
                return PipeDataWrapper.error(this.errorPrefix() + "[list-range:index,count]count\u5fc5\u987b\u5927\u4e8e0");
            }
            int toIndex = countInt + fromIndex;
            int size = collection.size();
            if (toIndex > size) {
                log.warn("\u9519\u8bef:[list-range:index,count] count\u503c\u5927\u4e8e\u8f93\u5165\u96c6\u5408\u7684\u5927\u5c0f");
                toIndex = size;
            }
            return PipeDataWrapper.success(collection.subList(fromIndex, toIndex));
        }
        catch (NumberFormatException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return PipeDataWrapper.error(this.errorPrefix() + "[list-range:index,count]index\u6216count\u8f6c\u6362\u9519\u8bef");
        }
    }

    @Override
    protected String filterName() {
        return "list-range";
    }
}

