/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxLengthFilter
extends BasePipeFilter<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(MaxLengthFilter.class);

    @Override
    protected String filterName() {
        return "max-length";
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.success("");
        }
        if (!(value instanceof String)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u8f93\u51fa\u6570\u636e\u53ea\u80fd\u662f\u5b57\u7b26\u4e32");
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (this.params().size() != 1) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4ec5\u652f\u63011\u4e2a\u53c2\u6570");
        }
        String param = this.params().get(0);
        if (StringUtils.isBlank(param)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u53c2\u6570\u4e3a\u7a7a");
        }
        param = param.trim();
        try {
            String val = value.toString();
            int maxInt = Integer.parseInt(param);
            int length = val.length();
            if (length <= maxInt) {
                return PipeDataWrapper.success(value);
            }
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u5b57\u7b26\u4e32\u957f\u5ea6\u5927\u4e8e:" + maxInt, value);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return PipeDataWrapper.error(this.errorPrefix() + "\u53c2\u6570\u8f6c\u6362\u6570\u5b57\u9519\u8bef", value);
        }
    }
}

