/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.provider.AbstractEchoFilter;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class PriorExtractStringFilter
extends AbstractEchoFilter {
    private static final int PARAMS_SIZE = 2;

    @Override
    protected String filterName() {
        return "prior-extract";
    }

    @Override
    protected PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(value instanceof String) && !(value instanceof Collection)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u8f93\u5165\u6570\u636e\u4e0d\u662f\u5b57\u7b26\u4e32\u6216\u96c6\u5408");
        }
        if (value instanceof String) {
            String result = null;
            for (String param : this.params()) {
                AbstractEchoFilter.ExtractIndex extractIndex;
                String serializable;
                String[] priorParams = PipeFilterUtils.getPipeFilterParams(param);
                if (Objects.isNull(priorParams) || priorParams.length != 2 || !StringUtils.isNotBlank(serializable = this.extractString(value, (extractIndex = this.indexHandle(priorParams)).begin(), extractIndex.end()))) continue;
                result = serializable;
                break;
            }
            if (Objects.isNull(result)) {
                return PipeDataWrapper.error(this.errorPrefix() + String.format("\u6ca1\u6709\u5339\u914d\u5230[%s]\u7684\u6570\u636e", String.join((CharSequence)",", this.params())), value);
            }
            return PipeDataWrapper.success(result);
        }
        ArrayList<String> result = new ArrayList<String>();
        Collection collection = (Collection)value;
        block1: for (Object item : collection) {
            for (String param : this.params()) {
                AbstractEchoFilter.ExtractIndex extractIndex;
                String serializable;
                String[] priorParams = PipeFilterUtils.getPipeFilterParams(param);
                if (Objects.isNull(priorParams) || priorParams.length != 2 || !StringUtils.isNotBlank(serializable = this.extractString(item, (extractIndex = this.indexHandle(priorParams)).begin(), extractIndex.end()))) continue;
                result.add(serializable);
                continue block1;
            }
        }
        if (PipeFilterUtils.isEmpty(result)) {
            return PipeDataWrapper.error(this.errorPrefix() + String.format("\u6ca1\u6709\u5339\u914d\u5230[%s]\u7684\u6570\u636e", String.join((CharSequence)",", this.params())), value);
        }
        return PipeDataWrapper.success(result);
    }
}

