/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.RandomStringUtils;
import icu.develop.expression.filter.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomStringFilter
extends BasePipeFilter<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(RandomStringFilter.class);
    public static final int RANDOM_MAX = 512;

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (this.params().size() != 2) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4ec5\u652f\u63012\u4e2a\u53c2\u6570");
        }
        String mode = this.params().get(0);
        String digit = this.params().get(1);
        if (StringUtils.isBlank(mode) || StringUtils.isBlank(digit)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6a21\u5f0f\u53ca\u4f4d\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!ModeEnums.isMode(mode)) {
            return PipeDataWrapper.error(this.errorPrefix() + "mode\u6a21\u5f0f\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        int digitInt = 12;
        if (StringUtils.isNumeric(digit)) {
            digitInt = RandomStringFilter.convert(digit, 6);
        }
        if (digitInt > 512) {
            return PipeDataWrapper.error(this.errorPrefix() + "digit\u4f4d\u6570\u6700\u5927\u503c\u4e3a512");
        }
        if (ModeEnums.isNumeric(mode)) {
            return PipeDataWrapper.success(RandomStringUtils.randomNumeric(digitInt));
        }
        if (ModeEnums.isAlphabetic(mode)) {
            return PipeDataWrapper.success(RandomStringUtils.randomAlphabetic(digitInt));
        }
        if (ModeEnums.isAlphanumeric(mode)) {
            return PipeDataWrapper.success(RandomStringUtils.randomAlphanumeric(digitInt));
        }
        return PipeDataWrapper.success(RandomStringUtils.randomNumeric(digitInt));
    }

    @Override
    protected String filterName() {
        return "random-string";
    }

    public static int convert(String mode, int defaultInt) {
        try {
            return Integer.parseInt(mode);
        }
        catch (Exception e) {
            log.warn("\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            return defaultInt;
        }
    }

    public static enum ModeEnums {
        ONE("1"),
        TWO("2"),
        TREE("3");

        private final String value;

        private ModeEnums(String value) {
            this.value = value;
        }

        public static boolean isAlphanumeric(String mode) {
            return ModeEnums.TREE.value.equals(mode);
        }

        public static boolean isAlphabetic(String mode) {
            return ModeEnums.TWO.value.equals(mode);
        }

        public static boolean isNumeric(String mode) {
            return ModeEnums.ONE.value.equals(mode);
        }

        public static boolean isMode(String mode) {
            for (ModeEnums modeEnums : ModeEnums.values()) {
                if (!modeEnums.value.equals(mode)) continue;
                return true;
            }
            return false;
        }
    }
}

