/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.constant.EscapeEnums;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceExcludeNumberFilter
extends BasePipeFilter<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(ReplaceExcludeNumberFilter.class);
    private static final int PARAMS_NUM = 3;

    @Override
    protected String filterName() {
        return "replace-exclude-number";
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PipeFilterUtils.isEmpty(this.params()) || this.params().size() != 3) {
            return PipeDataWrapper.error(this.errorPrefix() + "[replace-exclude-number:oldChar,newChar,all]\u4f20\u5165\u53c2\u6570\u4e0b\u6807\u4e3a\u7a7a\u6216\u662f\u8d85\u8fc7\u4e24\u4e2a");
        }
        String oldChar = this.params().get(0);
        if (StringUtils.isBlank(oldChar)) {
            return PipeDataWrapper.error(this.errorPrefix() + "[replace-exclude-number:oldChar,newChar,all]\u4e2d\u4f20\u5165\u53c2\u6570oldChar\u4e3a\u7a7a");
        }
        String newChar = this.params().get(1);
        if (StringUtils.isBlank(newChar)) {
            return PipeDataWrapper.error(this.errorPrefix() + "[replace-exclude-number:oldChar,newChar,all]\u4e2d\u4f20\u5165\u53c2\u6570newChar\u4e3a\u7a7a");
        }
        String all = this.params().get(2);
        if (StringUtils.isBlank(all)) {
            return PipeDataWrapper.error(this.errorPrefix() + "[replace-exclude-number:oldChar,newChar,all]\u4e2d\u4f20\u5165\u53c2\u6570all\u4e3a\u7a7a,\u4e0d\u662f1/0");
        }
        if (!StringUtils.isNumeric(all)) {
            return PipeDataWrapper.error(this.errorPrefix() + "[replace-exclude-number:oldChar,newChar,all]\u4e2d\u4f20\u5165\u53c2\u6570all\u9519\u8bef,\u4e0d\u662f1/0");
        }
        if (!(value instanceof String)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u8f93\u5165\u6570\u636e\u4e0d\u662f\u5b57\u7b26\u4e32");
        }
        try {
            int allInt;
            String oldCharEs = oldChar;
            EscapeEnums oldCharEscapeEnums = EscapeEnums.match(oldChar);
            if (Objects.nonNull((Object)oldCharEscapeEnums)) {
                oldCharEs = oldCharEscapeEnums.getCh();
            }
            String newCharEs = newChar;
            EscapeEnums newCharEscapeEnums = EscapeEnums.match(newChar);
            if (Objects.nonNull((Object)newCharEscapeEnums)) {
                newCharEs = newCharEscapeEnums.getCh();
            }
            if (1 == (allInt = Integer.parseInt(all))) {
                return PipeDataWrapper.success(ReplaceExcludeNumberFilter.replaceExcludeNumber((String)value, oldCharEs, newCharEs));
            }
            return PipeDataWrapper.success(ReplaceExcludeNumberFilter.replaceExcludeNumber((String)value, oldCharEs, newCharEs));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return PipeDataWrapper.error(this.errorPrefix() + "[replace-exclude-number:oldChar,newChar,all]\u4e2d\u4f20\u5165\u53c2\u6570all\u8f6c\u6362\u6570\u5b57\u9519\u8bef");
        }
    }

    public static String replaceExcludeNumber(String str, String oldStr, String newStr) {
        StringBuilder sb = new StringBuilder();
        while (StringUtils.isNotBlank(str) && str.contains(oldStr)) {
            String preStr = str.substring(0, str.indexOf(oldStr));
            String nextStr = str.substring(str.indexOf(oldStr));
            if (oldStr.equals(nextStr)) {
                sb.append(preStr).append(newStr);
                str = "";
                continue;
            }
            if (str.indexOf(oldStr) == 0) {
                str = str.substring(str.indexOf(oldStr) + 1);
                sb.append(newStr);
                continue;
            }
            char preChar = str.charAt(str.indexOf(oldStr) - 1);
            char nexChar = str.charAt(str.indexOf(oldStr) + 1);
            sb.append(preStr);
            if (Character.isDigit(preChar) && Character.isDigit(nexChar)) {
                sb.append(oldStr);
            } else {
                sb.append(newStr);
            }
            str = str.substring(str.indexOf(oldStr) + 1);
        }
        sb.append(str);
        return sb.toString();
    }
}

