/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstringFilter
extends BasePipeFilter<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(SubstringFilter.class);
    private static final int PARAMS_NUM = 2;

    @Override
    protected String filterName() {
        return "substring";
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PipeFilterUtils.isEmpty(this.params()) || this.params().size() != 2) {
            return PipeDataWrapper.error(this.errorPrefix() + "[substring:beginIndex,endIndex]\u4f20\u5165\u53c2\u6570\u4e0b\u6807\u4e3a\u7a7a\u6216\u662f\u8d85\u8fc7\u4e24\u4e2a");
        }
        String begin = this.params().get(0);
        if (StringUtils.isBlank(begin)) {
            return PipeDataWrapper.error(this.errorPrefix() + "[substring:beginIndex,endIndex]\u4e2d\u4f20\u5165\u53c2\u6570beginIndex\u4e3a\u7a7a");
        }
        String end = this.params().get(1);
        if (StringUtils.isBlank(end)) {
            return PipeDataWrapper.error(this.errorPrefix() + "[substring:beginIndex,endIndex]\u4e2d\u4f20\u5165\u53c2\u6570endIndex\u4e3a\u7a7a");
        }
        if (!(value instanceof String)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u8f93\u5165\u6570\u636e\u4e0d\u662f\u5b57\u7b26\u4e32");
        }
        try {
            int subLen;
            int length = ((String)value).length();
            int beginIndex = Integer.parseInt(begin);
            int endIndex = Integer.parseInt(end);
            if (endIndex > length) {
                endIndex = length;
            }
            if ((subLen = endIndex - beginIndex) < 0) {
                return PipeDataWrapper.error(this.errorPrefix() + "\u4e0b\u6807\u9519\u8bef,beginIndex==endIndex");
            }
            return PipeDataWrapper.success(((String)value).substring(beginIndex, endIndex));
        }
        catch (NumberFormatException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return PipeDataWrapper.error(this.errorPrefix() + "\u4e0b\u6807\u8f6c\u6362\u9519\u8bef");
        }
    }
}

