/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class TrimFilter
extends BasePipeFilter<Object, Object> {
    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (value instanceof String) {
            return PipeDataWrapper.success(value.toString().trim());
        }
        if (value instanceof Collection) {
            Collection valList = (Collection)value;
            if (PipeFilterUtils.isEmpty(valList)) {
                return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return PipeDataWrapper.success(valList.stream().filter(Objects::nonNull).map(str -> str.toString().trim()).collect(Collectors.toList()));
        }
        return PipeDataWrapper.error(this.errorPrefix() + "\u6307\u4ee4\u8f93\u5165\u6570\u636e\u4e0d\u662f\u5b57\u7b26\u4e32\u6216\u96c6\u5408");
    }

    @Override
    protected String filterName() {
        return "trim";
    }
}

