/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.provider;

import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.constant.EscapeEnums;
import icu.develop.expression.filter.provider.AbstractEchoFilter;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class WrapperFilter
extends AbstractEchoFilter {
    @Override
    protected String filterName() {
        return "wrapper";
    }

    @Override
    public PipeDataWrapper<Object> handlerApply(PipeDataWrapper<Object> wrapper) {
        String right;
        if (!this.verify(wrapper)) {
            return wrapper;
        }
        if (Objects.isNull(wrapper)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u8f93\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object value = wrapper.getData();
        if (Objects.isNull(value)) {
            return PipeDataWrapper.success("");
        }
        if (!(value instanceof String) && !(value instanceof Collection)) {
            return PipeDataWrapper.error(this.errorPrefix() + "\u4f20\u5165\u6570\u636e\u4e0d\u662f\u5b57\u7b26\u4e32\u6216\u96c6\u5408");
        }
        if (PipeFilterUtils.isEmpty(this.params())) {
            return PipeDataWrapper.success("");
        }
        String left = this.params().get(0);
        if (StringUtils.isBlank(left)) {
            left = "";
        } else {
            AbstractEchoFilter.Delimiter leftDelimiter = AbstractEchoFilter.Delimiter.ofValue(left);
            if (Objects.nonNull((Object)leftDelimiter)) {
                left = leftDelimiter.getDelimiter();
            } else {
                EscapeEnums leftEscapeEnums = EscapeEnums.match(left);
                if (Objects.nonNull((Object)leftEscapeEnums)) {
                    left = leftEscapeEnums.getCh();
                }
            }
        }
        if (this.params().size() > 1) {
            right = this.params().get(1);
            if (StringUtils.isNotBlank(right)) {
                AbstractEchoFilter.Delimiter rightDelimiter = AbstractEchoFilter.Delimiter.ofValue(right);
                if (Objects.nonNull((Object)rightDelimiter)) {
                    right = rightDelimiter.getDelimiter();
                } else {
                    EscapeEnums rightEscapeEnums = EscapeEnums.match(right);
                    if (Objects.nonNull((Object)rightEscapeEnums)) {
                        right = rightEscapeEnums.getCh();
                    }
                }
            } else {
                right = "";
            }
        } else {
            right = "";
        }
        if (value instanceof String) {
            String val2 = (String)value;
            if (StringUtils.isBlank(val2)) {
                return PipeDataWrapper.success("");
            }
            return PipeDataWrapper.success(left + val2 + right);
        }
        Collection collection = (Collection)value;
        if (PipeFilterUtils.isEmpty(collection)) {
            return PipeDataWrapper.success("");
        }
        String finalLeft = left;
        String finalRight = right;
        return PipeDataWrapper.success(collection.stream().map(val -> finalLeft + val + finalRight).collect(Collectors.toList()));
    }
}

