/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.utils;

import icu.develop.expression.filter.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;

public class NumberUtils {
    private NumberUtils() {
    }

    private static boolean hasFormat(FormatProperty formatProperty) {
        return formatProperty != null && !StringUtils.isEmpty(formatProperty.getFormat());
    }

    public static String format(Number num, FormatProperty formatProperty) {
        if (formatProperty == null || StringUtils.isEmpty(formatProperty.getFormat())) {
            if (num instanceof BigDecimal) {
                return ((BigDecimal)num).toPlainString();
            }
            return num.toString();
        }
        String format = formatProperty.getFormat();
        RoundingMode roundingMode = formatProperty.getRoundingMode();
        DecimalFormat decimalFormat = new DecimalFormat(format);
        decimalFormat.setRoundingMode(roundingMode);
        return decimalFormat.format(num);
    }

    public static Short parseShort(String string, FormatProperty formatProperty) throws ParseException {
        if (!NumberUtils.hasFormat(formatProperty)) {
            return new BigDecimal(string).shortValue();
        }
        return NumberUtils.parse(string, formatProperty).shortValue();
    }

    public static Long parseLong(String string, FormatProperty formatProperty) throws ParseException {
        if (!NumberUtils.hasFormat(formatProperty)) {
            return new BigDecimal(string).longValue();
        }
        return NumberUtils.parse(string, formatProperty).longValue();
    }

    public static Integer parseInteger(String string, FormatProperty formatProperty) throws ParseException {
        if (!NumberUtils.hasFormat(formatProperty)) {
            return new BigDecimal(string).intValue();
        }
        return NumberUtils.parse(string, formatProperty).intValue();
    }

    public static Float parseFloat(String string, FormatProperty formatProperty) throws ParseException {
        if (!NumberUtils.hasFormat(formatProperty)) {
            return Float.valueOf(new BigDecimal(string).floatValue());
        }
        return Float.valueOf(NumberUtils.parse(string, formatProperty).floatValue());
    }

    public static BigDecimal parseBigDecimal(String string, FormatProperty formatProperty) throws ParseException {
        if (!NumberUtils.hasFormat(formatProperty)) {
            return new BigDecimal(string);
        }
        return new BigDecimal(NumberUtils.parse(string, formatProperty).toString());
    }

    public static Byte parseByte(String string, FormatProperty formatProperty) throws ParseException {
        if (!NumberUtils.hasFormat(formatProperty)) {
            return new BigDecimal(string).byteValue();
        }
        return NumberUtils.parse(string, formatProperty).byteValue();
    }

    public static Double parseDouble(String string, FormatProperty formatProperty) throws ParseException {
        if (!NumberUtils.hasFormat(formatProperty)) {
            return new BigDecimal(string).doubleValue();
        }
        return NumberUtils.parse(string, formatProperty).doubleValue();
    }

    private static Number parse(String string, FormatProperty formatProperty) throws ParseException {
        String format = formatProperty.getFormat();
        RoundingMode roundingMode = formatProperty.getRoundingMode();
        DecimalFormat decimalFormat = new DecimalFormat(format);
        decimalFormat.setRoundingMode(roundingMode);
        decimalFormat.setParseBigDecimal(true);
        return decimalFormat.parse(string);
    }

    public static class FormatProperty {
        public static final FormatProperty EMPTY = new FormatProperty();
        private String format;
        private RoundingMode roundingMode;

        public String getFormat() {
            return this.format;
        }

        public RoundingMode getRoundingMode() {
            return this.roundingMode;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public void setRoundingMode(RoundingMode roundingMode) {
            this.roundingMode = roundingMode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FormatProperty)) {
                return false;
            }
            FormatProperty other = (FormatProperty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            RoundingMode this$roundingMode = this.getRoundingMode();
            RoundingMode other$roundingMode = other.getRoundingMode();
            return !(this$roundingMode == null ? other$roundingMode != null : !((Object)((Object)this$roundingMode)).equals((Object)other$roundingMode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FormatProperty;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            RoundingMode $roundingMode = this.getRoundingMode();
            result = result * 59 + ($roundingMode == null ? 43 : ((Object)((Object)$roundingMode)).hashCode());
            return result;
        }

        public String toString() {
            return "NumberUtils.FormatProperty(format=" + this.getFormat() + ", roundingMode=" + (Object)((Object)this.getRoundingMode()) + ")";
        }
    }
}

