/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.utils;

import icu.develop.expression.filter.utils.BeanMapUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;

public class PipeFilterUtils {
    private static final Logger log = LoggerFactory.getLogger(PipeFilterUtils.class);
    private static final String SUB_VAR_PREFIX = "(";
    private static final String SUB_VAR_SUFFIX = ")";
    private static final String PIPELINE_FLAG = "|";
    private static final String MULTI_PIPE_FLAG = "\\|";
    private static final String FILTER_PARAM_FLAG = ":";
    private static final String PARAM_FLAG = ",";
    private static final String VAR_FLAG = "\\.";

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static String trim(String source) {
        return StringUtils.isBlank(source) ? "" : source.trim();
    }

    public static String[] getPipelines(String pipelines) {
        return pipelines.split(MULTI_PIPE_FLAG);
    }

    public static String[] getPipeFilter(String pipeline) {
        return pipeline.split(FILTER_PARAM_FLAG);
    }

    public static String[] getPipeFilter(String pipeline, int limit) {
        return pipeline.split(FILTER_PARAM_FLAG, limit);
    }

    public static String[] getPipeFilterParams(String pipeFilter) {
        try {
            return PipeFilterUtils.split(pipeFilter, PARAM_FLAG);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return pipeFilter.split(PARAM_FLAG);
        }
    }

    public static boolean isPipeline(String variable) {
        return Objects.nonNull(variable) && variable.contains(PIPELINE_FLAG);
    }

    public static String getVariableName(String variable) {
        String[] varArray = PipeFilterUtils.getPipelines(variable);
        if (Objects.nonNull(varArray[0])) {
            return varArray[0].trim();
        }
        return null;
    }

    public static Object getValueOfMap(Map dataMap, String key) {
        if (StringUtils.isBlank(key)) {
            return null;
        }
        Map tempDataMap = dataMap;
        String[] keyArray = key.split(VAR_FLAG);
        for (int i = 0; i < keyArray.length; ++i) {
            Object obj;
            if (StringUtils.isBlank(keyArray[i]) || Objects.isNull(obj = tempDataMap.get(keyArray[i]))) continue;
            if (i == keyArray.length - 1) {
                return obj;
            }
            tempDataMap = obj instanceof BeanMap ? (BeanMap)obj : (obj instanceof Map ? (Map)obj : BeanMapUtils.create(obj));
        }
        return null;
    }

    public static String[] split(String source, String regex) {
        char ch = '\u0000';
        if ((regex.toCharArray().length == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff')) {
            int resultSize;
            int off = 0;
            int next = 0;
            ArrayList<String> list = new ArrayList<String>();
            while (true) {
                int next1 = source.indexOf(SUB_VAR_PREFIX, off);
                int next2 = source.indexOf(ch, off);
                if (next1 == -1 && next2 == -1) break;
                if (next1 != -1 && next2 != -1 && next1 < next2 || next1 != -1 && next2 == -1) {
                    next = next1;
                    off = next + 1;
                    if ((next = source.indexOf(SUB_VAR_SUFFIX, off)) != -1) {
                        list.add(source.substring(off, next));
                        off = next + 1;
                        continue;
                    }
                    throw new RuntimeException(String.format("\u5b50\u6307\u4ee4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9700\u8981\u7528()\u5305\u88f9, \u6e90\u5b57\u7b26\u4e32:%s, \u5206\u9694\u7b26:%s", source, regex));
                }
                next = next2;
                if (next == off && next != 0) {
                    off = next + 1;
                    continue;
                }
                list.add(source.substring(off, next));
                off = next + 1;
            }
            if (off == 0) {
                return new String[]{source};
            }
            list.add(source.substring(off, source.toCharArray().length));
            for (resultSize = list.size(); resultSize > 0 && ((String)list.get(resultSize - 1)).isEmpty(); --resultSize) {
            }
            String[] result = new String[resultSize];
            return list.subList(0, resultSize).toArray(result);
        }
        return Pattern.compile(regex).split(source);
    }
}

