/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.utils;

import icu.develop.expression.filter.BasePipeFilter;
import icu.develop.expression.filter.PipeDataWrapper;
import icu.develop.expression.filter.PipeFilterFactory;
import icu.develop.expression.filter.utils.PipeFilterUtils;
import icu.develop.expression.filter.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TemplateUtils {
    private static final Logger log = LoggerFactory.getLogger(TemplateUtils.class);
    private static final String ESCAPE_FILL_PREFIX = "\\\\\\{";
    private static final String ESCAPE_FILL_SUFFIX = "\\\\\\}";
    private static final String FILL_PREFIX = "{";
    private static final String FILL_SUFFIX = "}";
    private static final char IGNORE_CHAR = '\\';
    private static final String COLLECTION_PREFIX = ".";

    public static TemplateBuilder parse(String value) {
        int prefixIndex;
        if (StringUtils.isEmpty(value)) {
            return new TemplateBuilder(Boolean.TRUE, Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<String> variableList = new ArrayList<String>();
        ArrayList<String> prepareDataList = new ArrayList<String>();
        boolean onlyOneVariable = Boolean.TRUE;
        int startIndex = 0;
        int length = value.length();
        int lastPrepareDataIndex = 0;
        block0: while (startIndex < length && (prefixIndex = value.indexOf(FILL_PREFIX, startIndex)) >= 0) {
            int collectPrefixIndex;
            char prefixPrefixChar;
            if (prefixIndex != 0 && (prefixPrefixChar = value.charAt(prefixIndex - 1)) == '\\') {
                startIndex = prefixIndex + 1;
                continue;
            }
            int suffixIndex = -1;
            while (suffixIndex == -1 && startIndex < length) {
                suffixIndex = value.indexOf(FILL_SUFFIX, startIndex + 1);
                if (suffixIndex < 0) break block0;
                startIndex = suffixIndex + 1;
                char prefixSuffixChar = value.charAt(suffixIndex - 1);
                if (prefixSuffixChar != '\\') continue;
                suffixIndex = -1;
            }
            String variable = value.substring(prefixIndex + 1, suffixIndex);
            if (StringUtils.isEmpty(variable) || (collectPrefixIndex = variable.indexOf(COLLECTION_PREFIX)) == 0 && StringUtils.isEmpty(variable = variable.substring(collectPrefixIndex + 1))) continue;
            variableList.add(variable);
            if (lastPrepareDataIndex == prefixIndex) {
                prepareDataList.add("");
                if (lastPrepareDataIndex != 0) {
                    onlyOneVariable = Boolean.FALSE;
                }
            } else {
                String data = TemplateUtils.convertPrepareData(value.substring(lastPrepareDataIndex, prefixIndex));
                prepareDataList.add(data);
                onlyOneVariable = Boolean.FALSE;
            }
            lastPrepareDataIndex = suffixIndex + 1;
        }
        if (lastPrepareDataIndex == length) {
            prepareDataList.add("");
        } else {
            prepareDataList.add(TemplateUtils.convertPrepareData(value.substring(lastPrepareDataIndex)));
            onlyOneVariable = Boolean.FALSE;
        }
        return new TemplateBuilder(onlyOneVariable, variableList, prepareDataList);
    }

    private static String convertPrepareData(String prepareData) {
        prepareData = prepareData.replaceAll(ESCAPE_FILL_PREFIX, FILL_PREFIX);
        prepareData = prepareData.replaceAll(ESCAPE_FILL_SUFFIX, FILL_SUFFIX);
        return prepareData;
    }

    public static class TemplateBuilder {
        private final PipeFilterFactory pipeFilterFactory = PipeFilterFactory.createPipeFilter();
        private boolean onlyOneVariable = Boolean.TRUE;
        private final List<String> variable;
        private final List<String> prepareData;

        public TemplateBuilder(boolean onlyOneVariable, List<String> variable, List<String> prepareData) {
            this.onlyOneVariable = onlyOneVariable;
            this.variable = variable;
            this.prepareData = prepareData;
        }

        public TemplateBuilder registerPipeFilter(String name, Supplier<BasePipeFilter<Object, Object>> pipeFilter) {
            this.pipeFilterFactory.registerPipeFilter(name, pipeFilter);
            return this;
        }

        public Object render(Map<String, Object> params) {
            ArrayList<String> errorList = new ArrayList<String>();
            ArrayList<Object> variableValueList = new ArrayList<Object>();
            if (!PipeFilterUtils.isEmpty(this.variable)) {
                for (String var : this.variable) {
                    Object valueOfMap = PipeFilterUtils.getValueOfMap(params, PipeFilterUtils.getVariableName(var));
                    if (PipeFilterUtils.isPipeline(var)) {
                        PipeDataWrapper apply = ((BasePipeFilter)this.pipeFilterFactory.addParams(new String[]{var})).apply(PipeDataWrapper.success(valueOfMap));
                        if (apply.isErrorContinue() || apply.success()) {
                            if (!apply.success()) {
                                errorList.add(apply.getMessage());
                            }
                            variableValueList.add(apply.getData());
                            continue;
                        }
                        errorList.add(apply.getMessage());
                        variableValueList.add("");
                        continue;
                    }
                    variableValueList.add(valueOfMap);
                }
            }
            if (!CollectionUtils.isEmpty(errorList)) {
                log.warn(String.join((CharSequence)",", errorList));
            }
            if (this.onlyOneVariable) {
                return variableValueList.get(0);
            }
            StringBuilder renderContent = new StringBuilder();
            if (!PipeFilterUtils.isEmpty(this.prepareData)) {
                for (int i = 0; i < this.prepareData.size(); ++i) {
                    renderContent.append(this.prepareData.get(i));
                    if (i > variableValueList.size() - 1) continue;
                    renderContent.append(variableValueList.get(i));
                }
            }
            return renderContent.toString();
        }
    }
}

