/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.expression.filter.utils;

public enum TrafficUnit {
    B{

        @Override
        public double toB(double d) {
            return d;
        }

        @Override
        public double toKB(double d) {
            return d / 1024.0;
        }

        @Override
        public double toMB(double d) {
            return d / 1048576.0;
        }

        @Override
        public double toGB(double d) {
            return d / 1.073741824E9;
        }

        @Override
        public double convert(double d, TrafficUnit u) {
            return u.toB(d);
        }
    }
    ,
    KB{

        @Override
        public double toB(double d) {
            return 2.x(d, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public double toKB(double d) {
            return d;
        }

        @Override
        public double toMB(double d) {
            return d / 1024.0;
        }

        @Override
        public double toGB(double d) {
            return d / 1048576.0;
        }

        @Override
        public double convert(double d, TrafficUnit u) {
            return u.toKB(d);
        }
    }
    ,
    MB{

        @Override
        public double toB(double d) {
            return 3.x(d, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public double toKB(double d) {
            return 3.x(d, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public double toMB(double d) {
            return d;
        }

        @Override
        public double toGB(double d) {
            return d / 1024.0;
        }

        @Override
        public double convert(double d, TrafficUnit u) {
            return u.toMB(d);
        }
    }
    ,
    GB{

        @Override
        public double toB(double d) {
            return 4.x(d, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public double toKB(double d) {
            return 4.x(d, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public double toMB(double d) {
            return 4.x(d, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public double toGB(double d) {
            return d;
        }

        @Override
        public double convert(double d, TrafficUnit u) {
            return u.toGB(d);
        }
    };

    static final long C0 = 1L;
    static final long C1 = 1024L;
    static final long C2 = 0x100000L;
    static final long C3 = 0x40000000L;
    static final long MAX = Long.MAX_VALUE;

    static double x(double d, long m, long over) {
        if (d > (double)over) {
            return 9.223372036854776E18;
        }
        if (d < (double)(-over)) {
            return -9.223372036854776E18;
        }
        return d * (double)m;
    }

    public double convert(double sourceDuration, TrafficUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public double toB(double duration) {
        throw new AbstractMethodError();
    }

    public double toKB(double duration) {
        throw new AbstractMethodError();
    }

    public double toMB(double duration) {
        throw new AbstractMethodError();
    }

    public double toGB(double duration) {
        throw new AbstractMethodError();
    }

    public static TrafficUnit ofName(String name) {
        for (TrafficUnit value : TrafficUnit.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public static boolean isB(TrafficUnit trafficUnit) {
        return B.name().equals(trafficUnit.name());
    }

    public static boolean isKB(TrafficUnit trafficUnit) {
        return KB.name().equals(trafficUnit.name());
    }

    public static boolean isMB(TrafficUnit trafficUnit) {
        return MB.name().equals(trafficUnit.name());
    }

    public static boolean isGB(TrafficUnit trafficUnit) {
        return GB.name().equals(trafficUnit.name());
    }
}

