/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.global;

import icu.easyj.config.GlobalConfigSetter;
import icu.easyj.env.EnvironmentType;
import icu.easyj.env.RunMode;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GlobalProperties
implements InitializingBean {
    private String project;
    private String projectName;
    @Value(value="${easyj.global.application:${spring.application.name:}}")
    private String application;
    private String applicationName;
    private String env;
    private String envName;
    private EnvironmentType envType;
    private RunMode runMode;
    private Map<Object, Object> configs;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.hasText((String)this.project)) {
            GlobalConfigSetter.setProject((String)this.project.trim());
        }
        if (StringUtils.hasText((String)this.projectName)) {
            GlobalConfigSetter.setProjectName((String)this.projectName.trim());
        }
        if (StringUtils.hasText((String)this.application)) {
            GlobalConfigSetter.setApplication((String)this.application.trim());
        }
        if (StringUtils.hasText((String)this.applicationName)) {
            GlobalConfigSetter.setApplicationName((String)this.applicationName.trim());
        }
        if (StringUtils.hasText((String)this.env)) {
            GlobalConfigSetter.setEnv((String)this.env.trim());
        }
        if (StringUtils.hasText((String)this.envName)) {
            GlobalConfigSetter.setEnvName((String)this.envName.trim());
        }
        if (this.envType != null) {
            GlobalConfigSetter.setEnvType((EnvironmentType)this.envType);
        }
        if (this.runMode != null) {
            GlobalConfigSetter.setRunMode((RunMode)this.runMode);
        }
        if (!CollectionUtils.isEmpty(this.configs)) {
            GlobalConfigSetter.addConfigs(this.configs);
        }
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public EnvironmentType getEnvType() {
        return this.envType;
    }

    public void setEnvType(EnvironmentType envType) {
        this.envType = envType;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public Map<Object, Object> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<Object, Object> configs) {
        this.configs = configs;
    }
}

