/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.web.poi.excel.export;

import icu.easyj.poi.excel.annotation.Excel;
import icu.easyj.spring.boot.autoconfigure.web.poi.excel.export.ExcelExporterProperties;
import icu.easyj.web.poi.excel.DefaultExcelExporterImpl;
import icu.easyj.web.poi.excel.ExcelExportAspect;
import icu.easyj.web.poi.excel.ExcelExportConfig;
import icu.easyj.web.poi.excel.IExcelExporter;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={Workbook.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ExcelExporterProperties.class})
public class EasyjExcelExporterAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={Excel.class})
    @ConditionalOnProperty(name={"easyj.web.excel.exporter.type"}, havingValue="easyj", matchIfMissing=true)
    @ConditionalOnMissingBean
    public IExcelExporter defaultExcelExporter() {
        return new DefaultExcelExporterImpl();
    }

    @Bean
    public ExcelExportAspect excelExportAspect(IExcelExporter excelExporter, ExcelExporterProperties properties) {
        ExcelExportConfig config = new ExcelExportConfig();
        config.setListFieldName(properties.getListFieldName());
        return new ExcelExportAspect(excelExporter, config);
    }
}

