/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.global.configs;

import icu.easyj.config.GlobalConfigSetter;
import icu.easyj.config.GlobalConfigs;
import icu.easyj.env.EnvironmentType;
import icu.easyj.env.RunMode;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GlobalProperties
implements InitializingBean {
    private String area;
    private String areaName;
    private String project;
    private String projectName;
    @Value(value="${easyj.global.application:${spring.application.name:}}")
    private String application;
    private String applicationName;
    private String env;
    private String envName;
    private EnvironmentType envType;
    private RunMode runMode;
    private Boolean inUnitTest;
    private Map<Object, Object> configs;

    public void afterPropertiesSet() {
        if (StringUtils.hasText((String)this.area)) {
            GlobalConfigSetter.setArea((String)this.area.trim());
        }
        if (StringUtils.hasText((String)this.areaName)) {
            GlobalConfigSetter.setAreaName((String)this.areaName.trim());
        }
        if (StringUtils.hasText((String)this.project)) {
            GlobalConfigSetter.setProject((String)this.project.trim());
        }
        if (StringUtils.hasText((String)this.projectName)) {
            GlobalConfigSetter.setProjectName((String)this.projectName.trim());
        }
        if (StringUtils.hasText((String)this.application)) {
            GlobalConfigSetter.setApplication((String)this.application.trim());
        }
        if (StringUtils.hasText((String)this.applicationName)) {
            GlobalConfigSetter.setApplicationName((String)this.applicationName.trim());
        }
        if (StringUtils.hasText((String)this.env)) {
            GlobalConfigSetter.setEnv((String)this.env.trim());
        }
        if (StringUtils.hasText((String)this.envName)) {
            GlobalConfigSetter.setEnvName((String)this.envName.trim());
        }
        if (this.envType != null) {
            GlobalConfigSetter.setEnvType((EnvironmentType)this.envType);
        } else {
            String env = GlobalConfigs.getEnv();
            if (StringUtils.hasText((String)env)) {
                env = env.toUpperCase();
                for (EnvironmentType type : EnvironmentType.values()) {
                    if (!env.startsWith(type.name())) continue;
                    GlobalConfigSetter.setEnvType((EnvironmentType)type);
                    break;
                }
            }
        }
        if (this.runMode != null) {
            GlobalConfigSetter.setRunMode((RunMode)this.runMode);
        }
        if (this.inUnitTest != null) {
            GlobalConfigSetter.setInUnitTest((boolean)this.inUnitTest);
        }
        if (!CollectionUtils.isEmpty(this.configs)) {
            GlobalConfigSetter.addConfigs(this.configs);
        }
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public EnvironmentType getEnvType() {
        return this.envType;
    }

    public void setEnvType(EnvironmentType envType) {
        this.envType = envType;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public Boolean getInUnitTest() {
        return this.inUnitTest;
    }

    public void setInUnitTest(Boolean inUnitTest) {
        this.inUnitTest = inUnitTest;
    }

    public Map<Object, Object> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<Object, Object> configs) {
        this.configs = configs;
    }
}

