/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.configs;

import icu.easyj.config.GlobalConfigs;
import icu.easyj.core.env.EnvironmentType;
import icu.easyj.core.env.RunMode;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.StringUtils;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class GlobalProperties
implements InitializingBean {
    private String area;
    private String areaName;
    private String project;
    private String projectName;
    @Value(value="${easyj.global.application:${spring.application.name:}}")
    private String application;
    private String applicationName;
    private String env;
    private String envName;
    private EnvironmentType envType;
    private RunMode runMode;
    private Boolean inUnitTest;
    private Map<Object, Object> configs;

    public void afterPropertiesSet() {
        if (StringUtils.isNotBlank((CharSequence)this.area)) {
            GlobalConfigs.setArea((String)this.area.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.areaName)) {
            GlobalConfigs.setAreaName((String)this.areaName.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.project)) {
            GlobalConfigs.setProject((String)this.project.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.projectName)) {
            GlobalConfigs.setProjectName((String)this.projectName.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.application)) {
            GlobalConfigs.setApplication((String)this.application.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.applicationName)) {
            GlobalConfigs.setApplicationName((String)this.applicationName.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.env)) {
            GlobalConfigs.setEnv((String)this.env.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.envName)) {
            GlobalConfigs.setEnvName((String)this.envName.trim());
        }
        if (this.envType != null) {
            GlobalConfigs.setEnvType((EnvironmentType)this.envType);
        } else {
            String env = GlobalConfigs.getEnv();
            if (StringUtils.isNotBlank((CharSequence)env)) {
                env = env.toUpperCase();
                for (EnvironmentType type : EnvironmentType.values()) {
                    if (!env.startsWith(type.name())) continue;
                    GlobalConfigs.setEnvType((EnvironmentType)type);
                    break;
                }
            }
        }
        if (this.runMode != null) {
            GlobalConfigs.setRunMode((RunMode)this.runMode);
        }
        if (this.inUnitTest != null) {
            GlobalConfigs.setInUnitTest((boolean)this.inUnitTest);
        }
        if (!MapUtils.isEmpty(this.configs)) {
            GlobalConfigs.addConfigs(this.configs);
        }
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public EnvironmentType getEnvType() {
        return this.envType;
    }

    public void setEnvType(EnvironmentType envType) {
        this.envType = envType;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public Boolean getInUnitTest() {
        return this.inUnitTest;
    }

    public void setInUnitTest(Boolean inUnitTest) {
        this.inUnitTest = inUnitTest;
    }

    public Map<Object, Object> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<Object, Object> configs) {
        this.configs = configs;
    }
}

