/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.middleware.dwz.server;

import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.middleware.dwz.server.core.config.DwzServerTaskConfig;
import icu.easyj.middleware.dwz.server.core.controller.DwzRestController;
import icu.easyj.middleware.dwz.server.core.listener.DwzServerStartupApplicationListener;
import icu.easyj.middleware.dwz.server.core.service.IDwzCorrectErrorDataService;
import icu.easyj.middleware.dwz.server.core.service.IDwzServerService;
import icu.easyj.middleware.dwz.server.core.service.impls.DefaultDwzCorrectErrorDataServiceImpl;
import icu.easyj.middleware.dwz.server.core.service.impls.DefaultDwzServerServiceImpl;
import icu.easyj.middleware.dwz.server.core.store.IDwzLogStore;
import icu.easyj.middleware.dwz.server.core.store.impls.db.DataBaseDwzLogStoreImpl;
import icu.easyj.middleware.dwz.server.core.task.EasyjDwzServerTask;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={DwzRestController.class})
@ConditionalOnProperty(value={"easyj.middleware.dwz.server.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
@ComponentScan(value={"icu.easyj.middleware.dwz.server.core.controller"})
public class EasyjMiddleWareDwzServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public IDwzLogStore dataBaseDwzLogStore(JdbcTemplate primaryJdbcTemplate, ISequenceService sequenceService) {
        return new DataBaseDwzLogStoreImpl(primaryJdbcTemplate, sequenceService);
    }

    @Bean
    @ConditionalOnMissingBean
    public IDwzServerService defaultDwzServerService(IDwzLogStore logStore) {
        return new DefaultDwzServerServiceImpl(logStore);
    }

    @Bean
    @ConditionalOnMissingBean
    public IDwzCorrectErrorDataService defaultDwzCorrectErrorDataService(IDwzLogStore dwzLogStore, ISequenceService sequenceService) {
        return new DefaultDwzCorrectErrorDataServiceImpl(dwzLogStore, sequenceService);
    }

    @Bean
    public DwzServerStartupApplicationListener dwzServerInitApplicationListener(IDwzCorrectErrorDataService dwzCorrectErrorDataService) {
        return new DwzServerStartupApplicationListener(dwzCorrectErrorDataService);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"easyj.middleware.dwz.server.task.enabled"}, matchIfMissing=true)
    @EnableScheduling
    public static class EasyjDwzServerTaskConfiguration {
        @Bean
        @ConfigurationProperties(value="easyj.middleware.dwz.server.task")
        public DwzServerTaskConfig dwzServerTaskProperties() {
            return new DwzServerTaskConfig();
        }

        @Bean
        @ConditionalOnMissingBean
        public EasyjDwzServerTask easyjDwzServerTask(IDwzLogStore dwzLogStore, DwzServerTaskConfig dwzServerTaskConfig) {
            return new EasyjDwzServerTask(dwzLogStore, dwzServerTaskConfig);
        }
    }
}

