/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.configs;

import cn.hutool.core.lang.Snowflake;
import icu.easyj.config.ServerConfigs;
import icu.easyj.spring.boot.autoconfigure.configs.AppProperties;
import icu.easyj.spring.boot.autoconfigure.configs.EnvironmentProperties;
import icu.easyj.spring.boot.autoconfigure.configs.ServerProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

public class EasyjConfigsAutoConfiguration {
    @Bean
    @Lazy(value=false)
    @ConfigurationProperties(value="easyj.app")
    public AppProperties projectProperties() {
        return new AppProperties();
    }

    @Bean
    @Lazy(value=false)
    @ConfigurationProperties(value="easyj.env")
    public EnvironmentProperties environmentProperties(@Value(value="${spring.profiles.active:}") String[] activeProfiles) {
        EnvironmentProperties properties = new EnvironmentProperties();
        if (activeProfiles != null && activeProfiles.length > 0) {
            properties.setEnv(activeProfiles[0]);
        }
        return properties;
    }

    @Bean
    @Lazy(value=false)
    @ConfigurationProperties(value="easyj.server")
    public ServerProperties serverProperties() {
        return new ServerProperties();
    }

    @Bean
    @Lazy(value=true)
    public Snowflake snowflake(ServerProperties serverProperties) {
        return ServerConfigs.getSnowflake();
    }
}

