/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.configs;

import icu.easyj.config.EnvironmentConfigs;
import icu.easyj.core.env.EnvironmentType;
import icu.easyj.core.env.RunMode;
import icu.easyj.core.util.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class EnvironmentProperties
implements InitializingBean {
    private String env;
    private String envName;
    private EnvironmentType envType;
    private RunMode runMode;
    private Boolean inUnitTest;

    public void afterPropertiesSet() {
        if (StringUtils.isNotBlank((CharSequence)this.env)) {
            EnvironmentConfigs.setEnv((String)this.env.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.envName)) {
            EnvironmentConfigs.setEnvName((String)this.envName.trim());
        }
        if (this.envType != null) {
            EnvironmentConfigs.setEnvType((EnvironmentType)this.envType);
        } else {
            String env = EnvironmentConfigs.getEnv();
            if (StringUtils.isNotBlank((CharSequence)env)) {
                env = env.toUpperCase();
                for (EnvironmentType type : EnvironmentType.values()) {
                    if (!env.startsWith(type.name())) continue;
                    EnvironmentConfigs.setEnvType((EnvironmentType)type);
                    break;
                }
            }
        }
        if (this.runMode != null) {
            EnvironmentConfigs.setRunMode((RunMode)this.runMode);
        }
        if (this.inUnitTest != null) {
            EnvironmentConfigs.setInUnitTest((boolean)this.inUnitTest);
        }
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public EnvironmentType getEnvType() {
        return this.envType;
    }

    public void setEnvType(EnvironmentType envType) {
        this.envType = envType;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public Boolean getInUnitTest() {
        return this.inUnitTest;
    }

    public void setInUnitTest(Boolean inUnitTest) {
        this.inUnitTest = inUnitTest;
    }
}

