/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.login;

import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.jwt.IJwt;
import icu.easyj.login.DefaultLoginValidatorExceptionHandler;
import icu.easyj.login.ILoginProperties;
import icu.easyj.login.ILoginTokenBuilder;
import icu.easyj.login.ILoginValidatorExceptionHandler;
import icu.easyj.login.JwtLoginTokenBuilder;
import icu.easyj.login.JwtLoginTokenBuilderProperties;
import icu.easyj.login.LoginFilter;
import icu.easyj.login.LoginProperties;
import icu.easyj.login.LoginValidatorAspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;

@ConditionalOnClass(value={LoginProperties.class})
@ConditionalOnProperty(value={"easyj.login.enabled"})
public class EasyjLoginAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ILoginProperties.class})
    @ConfigurationProperties(value="easyj.login")
    public LoginProperties loginProperties() {
        return new LoginProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="easyj.login.jwt-token-builder")
    public JwtLoginTokenBuilderProperties jwtLoginTokenBuilderProperties() {
        return new JwtLoginTokenBuilderProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ILoginTokenBuilder loginTokenBuilder(ILoginProperties properties, JwtLoginTokenBuilderProperties loginTokenBuilderProperties) {
        Assert.notNull((Object)loginTokenBuilderProperties.getAlgorithmId(), (String)"Login: 'algorithmId' \u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)loginTokenBuilderProperties.getSecretKey(), (String)"Login: 'secretKey' \u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)loginTokenBuilderProperties.getSecretKeyAlgorithm(), (String)"Login: 'secretKeyAlgorithm' \u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        Object[] jwtArgs = new Object[]{loginTokenBuilderProperties.getAlgorithmId(), loginTokenBuilderProperties.getSecretKey(), loginTokenBuilderProperties.getSecretKeyAlgorithm()};
        IJwt jwt = (IJwt)EnhancedServiceLoader.load(IJwt.class, (String)loginTokenBuilderProperties.getJwtType(), (Object[])jwtArgs);
        return new JwtLoginTokenBuilder(jwt, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public LoginFilter loginFilter(ILoginTokenBuilder loginTokenBuilder, ILoginProperties properties) {
        return new LoginFilter(loginTokenBuilder, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ILoginValidatorExceptionHandler defaultLoginValidatorExceptionHandler() {
        return new DefaultLoginValidatorExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public LoginValidatorAspect loginValidatorAspect(ILoginValidatorExceptionHandler loginValidatorExceptionHandler) {
        return new LoginValidatorAspect(loginValidatorExceptionHandler);
    }
}

