/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.sequence;

import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.core.sequence.impls.AtomicLongSequenceServiceImpl;
import icu.easyj.db.sequence.impls.DataBaseSequenceServiceImpl;
import icu.easyj.redis.sequence.impls.SpringRedisSequenceServiceImpl;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Lazy
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"easyj.sequence.type"})
public class EasyjSequenceAutoConfiguration {

    @Lazy
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"easyj.sequence.type"}, havingValue="atomic-long")
    static class AtomicLongSequenceServiceConfiguration {
        AtomicLongSequenceServiceConfiguration() {
        }

        @Bean
        public ISequenceService atomicLongSequenceService() {
            return new AtomicLongSequenceServiceImpl();
        }
    }

    @Lazy
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"easyj.sequence.type"}, havingValue="db")
    static class DataBaseSequenceServiceConfiguration {
        DataBaseSequenceServiceConfiguration() {
        }

        @Bean
        public ISequenceService dataBaseSequenceService(DataSource primaryDataSource) {
            return new DataBaseSequenceServiceImpl(primaryDataSource);
        }
    }

    @Lazy
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"easyj.sequence.type"}, havingValue="redis")
    static class RedisSequenceServiceConfiguration {
        RedisSequenceServiceConfiguration() {
        }

        @Bean
        public ISequenceService redisSequenceServiceImpl(RedisConnectionFactory connectionFactory) {
            return new SpringRedisSequenceServiceImpl(connectionFactory);
        }
    }
}

