/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.loopholecheck;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.EasyjFastjsonBugfixUtils;
import icu.easyj.core.util.jar.JarInfo;
import icu.easyj.core.util.jar.JarUtils;
import icu.easyj.core.util.version.ExistLoopholeVersionError;
import icu.easyj.spring.boot.autoconfigure.jar.EasyjDependenciesAutoConfiguration;
import icu.easyj.spring.boot.autoconfigure.loopholecheck.LoopholeCheckProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.Ordered;

@Lazy(value=false)
@ConditionalOnClass(value={JSON.class})
@ConditionalOnProperty(value={"easyj.loophole-check.fastjson"}, matchIfMissing=true)
@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={EasyjDependenciesAutoConfiguration.class})
@EnableConfigurationProperties(value={LoopholeCheckProperties.class})
public class EasyjFastjsonLoopholeCheckAutoConfiguration
implements Ordered {
    public EasyjFastjsonLoopholeCheckAutoConfiguration(LoopholeCheckProperties properties) {
        JarInfo jarInfo = JarUtils.getJar((String)"com.alibaba", (String)"fastjson");
        if (jarInfo != null && EasyjFastjsonBugfixUtils.isLoopholeVersion((String)jarInfo.getVersion())) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("");
            logger.warn("==>");
            logger.warn("fastjson \u4e25\u91cd\u6f0f\u6d1e\u8b66\u544a\uff1a");
            logger.warn("\u5f53\u524d fastjson \u7248\u672c\u53f7\u4e3a\uff1a{}\u3002\u8be5\u7248\u672c\u5b58\u5728\u8fdc\u7a0b\u4ee3\u7801\u6267\u884c\u6f0f\u6d1e\uff0c\u8bf7\u5c3d\u5feb\u5347\u7ea7\u81f31.2.69\u53ca\u4ee5\u4e0a\u7248\u672c\u3002", (Object)jarInfo.getVersion());
            logger.warn("\u4e3a\u4e86\u907f\u514d\u5347\u7ea7\u5bfc\u81f4\u7684\u517c\u5bb9\u6027\u95ee\u9898\uff0c\u4e5f\u53ef\u5347\u7ea7\u81f3\u4f4e\u7248\u672c\u7684\u6700\u65b0\u6f0f\u6d1e\u4fee\u590d\u7248\u672c\uff08\u683c\u5f0f\u5982 '1.2.68.sec10' \u7684\u7248\u672c\u53f7\uff09\u3002");
            logger.warn("fastjson\u7248\u672c\u53f7\u8bf7\u67e5\u770b\u94fe\u63a5\uff08\u542b\u4f4e\u7248\u672c\u6f0f\u6d1e\u4fee\u590d\u7248\u672c\uff09\uff1ahttps://repo1.maven.org/maven2/com/alibaba/fastjson");
            logger.warn("\u5982\u679c\u60a8\u7684fastjson\u7248\u672c\u5df2\u7ecf\u662f\u4e0d\u5b58\u5728\u6f0f\u6d1e\u7684\u7248\u672c\uff0c\u60a8\u53ef\u4ee5\u6dfb\u52a0\u914d\u7f6e\u5173\u95ed\u8be5\u8b66\u544a\uff1aeasyj.loophole-check.fastjson=false");
            logger.warn("<==");
            logger.warn("");
            if (properties.isNeedThrowIfExist()) {
                throw new ExistLoopholeVersionError("\u5f53\u524dfastjson\u7248\u672c\u5b58\u5728\u8fdc\u7a0b\u4ee3\u7801\u6267\u884c\u6f0f\u6d1e\uff0c\u8bf7\u5c3d\u5feb\u66f4\u65b0\u81f31.2.69\u53ca\u4ee5\u4e0a\u7248\u672c\uff0c\u6216\u6700\u65b0\u6f0f\u6d1e\u4fee\u590d\u7248\u672c\uff01");
            }
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

