/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.autoconfigure.web.param.crypto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.EasyjFastjsonBugfixUtils;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import icu.easyj.config.EnvironmentConfigs;
import icu.easyj.spring.boot.util.FilterRegistrationUtils;
import icu.easyj.web.filter.IFilterProperties;
import icu.easyj.web.param.crypto.FastJsonParamCryptoHttpMessageConverter;
import icu.easyj.web.param.crypto.IParamCryptoFilterProperties;
import icu.easyj.web.param.crypto.IParamCryptoHandler;
import icu.easyj.web.param.crypto.IParamCryptoHandlerProperties;
import icu.easyj.web.param.crypto.ParamCryptoFilter;
import icu.easyj.web.param.crypto.impls.DefaultParamCryptoFilterPropertiesImpl;
import icu.easyj.web.param.crypto.impls.DefaultParamCryptoHandlerImpl;
import icu.easyj.web.param.crypto.impls.DefaultParamCryptoHandlerPropertiesImpl;
import icu.easyj.web.spring.WebMvcConfigurerAdapter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Lazy
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ParamCryptoFilter.class, WebMvcConfigurer.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(value={"easyj.web.param-crypto.filter.enabled"})
public class EasyjWebParamCryptoAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.mvc.converters.preferred-json-mapper";

    @Bean
    @ConditionalOnMissingBean(value={IParamCryptoFilterProperties.class})
    @ConfigurationProperties(value="easyj.web.param-crypto.filter")
    public DefaultParamCryptoFilterPropertiesImpl defaultParamCryptoFilterProperties() {
        return new DefaultParamCryptoFilterPropertiesImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={IParamCryptoHandlerProperties.class})
    @ConfigurationProperties(value="easyj.web.param-crypto.handler")
    public DefaultParamCryptoHandlerPropertiesImpl defaultParamCryptoHandlerProperties() {
        return new DefaultParamCryptoHandlerPropertiesImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public IParamCryptoHandler defaultParamCryptoHandler(IParamCryptoHandlerProperties properties) {
        return new DefaultParamCryptoHandlerImpl(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ParamCryptoFilter paramEncryptFilter(IParamCryptoFilterProperties filterProperties, IParamCryptoHandlerProperties handlerProperties, IParamCryptoHandler handler) {
        return new ParamCryptoFilter(filterProperties, handlerProperties, handler);
    }

    @Bean
    public FilterRegistrationBean paramEncryptFilterRegistration(ParamCryptoFilter paramCryptoFilter) {
        return FilterRegistrationUtils.register((Filter)paramCryptoFilter, (IFilterProperties)paramCryptoFilter.getFilterProperties(), (Integer)-75);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JSON.class})
    @ConditionalOnProperty(value={"spring.mvc.converters.preferred-json-mapper"}, havingValue="fastjson")
    static class FastjsonParamCryptoHttpMessageConverterAutoConfiguration
    implements WebMvcConfigurerAdapter {
        private final ParamCryptoFilter paramCryptoFilter;

        public FastjsonParamCryptoHttpMessageConverterAutoConfiguration(ParamCryptoFilter paramCryptoFilter) {
            this.paramCryptoFilter = paramCryptoFilter;
        }

        public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
            FastJsonParamCryptoHttpMessageConverter httpMessageConverter = new FastJsonParamCryptoHttpMessageConverter(this.paramCryptoFilter);
            httpMessageConverter.setDefaultCharset(StandardCharsets.UTF_8);
            FastJsonConfig fastJsonConfig = new FastJsonConfig();
            fastJsonConfig.setSerializerFeatures(this.getFeatures());
            fastJsonConfig.setCharset(StandardCharsets.UTF_8);
            SerializeConfig serializeConfig = EasyjFastjsonBugfixUtils.newSerializeConfig();
            serializeConfig.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
            fastJsonConfig.setSerializeConfig(serializeConfig);
            httpMessageConverter.setFastJsonConfig(fastJsonConfig);
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            mediaTypes.add(MediaType.TEXT_PLAIN);
            mediaTypes.add(MediaType.APPLICATION_JSON);
            mediaTypes.add(MediaType.valueOf((String)"application/*+json"));
            httpMessageConverter.setSupportedMediaTypes(mediaTypes);
            converters.add(0, (HttpMessageConverter<?>)httpMessageConverter);
        }

        private SerializerFeature[] getFeatures() {
            if (EnvironmentConfigs.isDebugMode()) {
                return new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.UseISO8601DateFormat, SerializerFeature.SortField, SerializerFeature.PrettyFormat};
            }
            return new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.UseISO8601DateFormat};
        }
    }
}

