/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.test;

import icu.easyj.spring.boot.test.MockRequest;
import javax.servlet.Filter;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class BaseSpringBootMockMvcTest {
    @Autowired
    protected WebApplicationContext wac;
    protected MockMvc mockMvc;
    private final Filter[] filters;

    public BaseSpringBootMockMvcTest(Filter ... filters) {
        this.filters = filters;
    }

    @BeforeEach
    public void beforeEach() {
        this.initMockMvc(this.filters);
    }

    protected void initMockMvc(Filter ... filters) {
        DefaultMockMvcBuilder builder = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.wac);
        if (this.filters != null && this.filters.length > 0 && this.filters != filters) {
            builder.addFilters(this.filters);
            if (filters != null && filters.length > 0) {
                for (Filter f : filters) {
                    Assert.notNull((Object)f, (String)"filters cannot contain null values");
                    boolean isAdded = false;
                    for (Filter f0 : this.filters) {
                        if (f0 != f) continue;
                        isAdded = true;
                        break;
                    }
                    if (isAdded) continue;
                    builder.addFilter(f, new String[0]);
                }
            }
        } else if (filters != null && filters.length > 0) {
            builder.addFilters(filters);
        }
        this.mockMvc = builder.build();
    }

    protected MockRequest mockGet(String urlTemplate, Object ... uriVars) {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.get((String)urlTemplate, (Object[])uriVars);
        return new MockRequest(this.mockMvc, builder);
    }

    protected MockRequest mockPost(String urlTemplate, Object ... uriVars) {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.post((String)urlTemplate, (Object[])uriVars);
        return new MockRequest(this.mockMvc, builder);
    }

    protected MockRequest mockPut(String urlTemplate, Object ... uriVars) {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.put((String)urlTemplate, (Object[])uriVars);
        return new MockRequest(this.mockMvc, builder);
    }

    protected MockRequest mockPatch(String urlTemplate, Object ... uriVars) {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.patch((String)urlTemplate, (Object[])uriVars);
        return new MockRequest(this.mockMvc, builder);
    }

    protected MockRequest mockDelete(String urlTemplate, Object ... uriVars) {
        MockHttpServletRequestBuilder builder = MockMvcRequestBuilders.delete((String)urlTemplate, (Object[])uriVars);
        return new MockRequest(this.mockMvc, builder);
    }
}

